package itez.plat.base.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.service.common.ICompService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.base.model.Comp;
import itez.plat.base.service.CompService;
import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class CompServiceImpl extends EModelService<Comp> implements CompService, ICompService {

	@Override
	@Cache.able(cache="COMP_BY_ID", key="#(id)")
	public Comp findById(String id) {
		return super.findById(id);
	}

	@Override
	@Cache.able(cache="COMP_BY_DOMAIN", key="#(domain)")
	public Comp findByDomain(String domain) {
		Querys qs = Querys.and(Query.eq("domain", domain));
		return selectFirst(qs);
	}

}