package itez.plat.base.model;

import java.math.BigDecimal;
import itez.core.runtime.service.ServiceManager;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.service.common.IUserService;
import itez.plat.base.model.base.BaseUser;
import itez.plat.base.service.DeptService;
import itez.plat.base.service.PostLevelService;
import itez.plat.base.service.PostService;
import itez.plat.base.service.VertService;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class User extends BaseUser<User> implements IUser {
	
	private transient final IUserService us = ServiceManager.me.getUserService();
	private transient final DeptService ds = ServiceManager.me.getService(DeptService.class);
	private transient final PostService ps = ServiceManager.me.getService(PostService.class);
	private transient final PostLevelService pls = ServiceManager.me.getService(PostLevelService.class);
	private transient final VertService vs = ServiceManager.me.getService(VertService.class);

	/**
	 * 实现几个扩展方法，便于通过人员对象获取更多信息
	 */

	public Dept getDept(){
		if(getDeptId() == null) return null;
		return ds.findById(getDeptId());
	}
	
	public Post getPost(){
		if(super.getPostId() == null) return null;
		Post post = ps.findById(getPostId());
		return post;
	}
	
	public PostLevel getPostLevel(){
		Post post = getPost();
		if(post == null) return null;
		String plevelId = post.getLevelId();
		if(plevelId == null) return null;
		PostLevel plevel = pls.findById(plevelId);
		return plevel;
	}
	
	public Vert getVert(){
		PostLevel plevel = getPostLevel();
		if(plevel == null) return null;
		String vertId = plevel.getVertId();
		if(vertId == null) return null;
		Vert vert = vs.findById(vertId);
		return vert;
	}

	/**
	 * 重写两个属性取值
	 * 1、系数：默认取个人系数，为空时取岗位系数
	 * 2、角色：默认取个人角色，为空时取岗位角色
	 */
	
	@Override
	public BigDecimal getCoef() {
		if(super.getCoef() != null) return super.getCoef();
		Post post = getPost();
		if(post == null) return null;
		return post.getCoef();
	}
	
	@Override
	public String getRoleIds() {
		if(super.getRoleIds() != null) return super.getRoleIds();
		Post post = getPost();
		if(post == null) return null;
		return post.getRoleIds();
	}
	
	/**
	 * 在Model中实现鉴权方法
	 * 
	 * 主要为了实现视图模板中的鉴权需求
	 * 
	 * 模板中鉴权方法：
	 * 
	 *   #if(session.user.checkRole("...")) ...
	 */
	
	@Override
	public boolean checkRole(String roleCode) {
		return us.checkRole(this, roleCode);
	}

	@Override
	public boolean checkRoles(String... roleCodeArr) {
		return us.checkRoles(this, roleCodeArr);
	}

	@Override
	public boolean checkRolesAny(String... roleCodeArr) {
		return us.checkRolesAny(this, roleCodeArr);
	}

	@Override
	public boolean checkPerm(String permCode) {
		return us.checkPerm(this, permCode);
	}

	@Override
	public boolean checkPerms(String... permCodeArr) {
		return us.checkPerms(this, permCodeArr);
	}

	@Override
	public boolean checkPermsAny(String... permCodeArr) {
		return us.checkPermsAny(this, permCodeArr);
	}
	
	
}
