package itez.plat.base.controller.test;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.runtime.session.ERequestBean;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EController;
import itez.kit.ERet;
import itez.plat.base.queue.QueueProcessService;
import itez.plat.base.service.QueueTestService;

/**
 * 平台测试控制器
 * 
 * @author netwild
 *
 */
@ControllerDefine(key = "/test", summary = "测试", view = "/test")
public class TestController extends EController {
	
	@Inject
	QueueProcessService queueProService;
	
	@Inject
	QueueTestService queueService;
	
	/**
	 * 测试页（spa）
	 */
	@AuthRequire.Logined
	public void spa(){
		render("spa.html");
	}
	
	/**
	 * 测试页（element）
	 */
	@AuthRequire.Guest
	public void element(){
		render("element.html");
	}
	
	@AuthRequire.Guest
	public void submit(){
		Entityone test = parseBean(Entityone.class);
		renderJson(test);
	}

	@AuthRequire.Guest
	public void queue(){
		render("queueTest.html");
	}

	@AuthRequire.Guest
	public void queueSubmit(String info, Boolean fromQueue){
		String msg = "";
		if(fromQueue){
			ERequestBean bean = request().wrapper(QueueTestService.class);
			try {
				queueProService.offer(bean);
				msg = "已提交到队列";
			} catch (Exception e) {
				msg = "发生错误：" + e.getMessage();
			}
		}else{
			queueService.addNew(info, fromQueue);
			msg = "普通提交操作完成";
		}
		renderJson(ERet.ok(msg));
	}

}
