package itez.plat.base.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.kit.HashKit;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EController;
import itez.kit.EStr;
import itez.plat.base.model.Dept;
import itez.plat.base.model.Role;
import itez.plat.base.model.User;
import itez.plat.base.service.DeptService;
import itez.plat.base.service.RoleService;
import itez.plat.base.service.UserService;

@ControllerDefine(key = "/insUser", summary = "成员管理", view = "/")
@AuthRequire.Logined
public class InsUserController extends EController {

	@Inject
	UserService us;
	
	@Inject
	DeptService ds;
	
	@Inject
	RoleService rs;
	
	public void index(){
		User user = (User) session().getUser();
		String roleIds = user.getRoleIds();
		List<Role> roles = rs.findByIds(roleIds);
		String compId = attr().getComp().getId();
		Dept rootDept = ds.getRootDept(compId);
		String pid = getPara("pid", rootDept.getId());
		List<Dept> depts = ds.getAllDepts(compId);
		List<User> users = us.getInsUsers(attr().getDomain(), pid);
		setAttr("pid", pid);
		setAttr("rootDept", rootDept);
		setAttr("depts", depts);
		setAttr("users", users);
		setAttr("roles", roles);
		render("insUser.html");
	}
	
	public void add(){
		String pid = getPara("pid");
		String loginName = getPara("loginName");
		String loginPass = getPara("loginPass", loginName);
		User user = new User();
		user.setDomain(attr().getDomain());
		user.setType(1);
		user.setCaption(getPara("caption"));
		user.setLoginName(loginName);
		user.setLevel(0);
		user.setRoleIds(EStr.parseArray(getParaValues("roleIds")));
		user.setDeptId(pid);
		us.add(user, loginPass);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void modify(){
		String pid = getPara("pid");
		String id = getPara("id");
		User user = (User) us.findById(id);
		user.setCaption(getPara("caption"));
		user.setLoginName(getPara("loginName"));
		user.setRoleIds(EStr.parseArray(getParaValues("roleIds")));
		String loginPass = getPara("loginPass");
		if(EStr.notEmpty(loginPass)) user.setLoginPass(HashKit.md5(loginPass + user.getSalt()));
		us.modify(user);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void remove(){
		String pid = getPara("pid");
		String ids = getPara("ids");
		us.remove(attr().getDomain(), ids);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
}
