package itez.plat.base.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EController;
import itez.plat.base.model.Dict;
import itez.plat.base.service.DictService;

@AuthRequire.Logined
@ControllerDefine(key = "/dict", summary = "字典管理", view = "/")
public class DictController extends EController {

	@Inject
	DictService dictService;
	
	public void index(){
		List<Dict> dicts = dictService.select(null, "groupCode, sort");
		setAttr("dicts", dicts);
		render("dict.html");
	}
	
	public void add(){
		Dict dict = getBean(Dict.class, "");
		dictService.save(dict);
		redirect(attr().getCtrl() + "/dict");
	}
	
	public void modify(){
		Dict dict = getBean(Dict.class, "");
		dictService.update(dict);
		redirect(attr().getCtrl() + "/dict");
	}
	
	public void remove(String codes){
		dictService.deleteByCodes(codes);
		redirect(attr().getCtrl() + "/dict");
	}
	
}
