package itez.plat.base.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EController;
import itez.kit.EStr;
import itez.plat.base.model.Dept;
import itez.plat.base.service.DeptService;

@ControllerDefine(key = "/dept", summary = "部门管理", view = "/")
@AuthRequire.Logined
public class DeptController extends EController {

	@Inject
	DeptService ds;
	
	public void index(){
		String compId = attr().getComp().getId();
		Dept rootDept = ds.getRootDept(compId);
		List<Dept> depts = ds.getAllDepts(compId);
		setAttr("pid", getPara("pid", rootDept.getId()));
		setAttr("rootDept", rootDept);
		setAttr("depts", depts);
		render("dept.html");
	}
	
	public void add(){
		String compId = attr().getComp().getId();
		String pid = getPara("pid");
		String caption = getPara("caption");
		String summary = getPara("summary");
		Integer level = getParaToInt("level", 1);
		Dept parent = ds.findById(pid);
		Dept last = ds.getLastDept(compId, pid);
		Integer sort = last == null ? 1 : last.getSort() + 1;
		String path = String.format("%s_%s", parent.getPath(), EStr.addPrefix(sort, 3));
		Dept dept = new Dept();
		dept.setCompId(compId);
		dept.setPid(pid);
		dept.setCaption(caption);
		dept.setSummary(summary);
		dept.setLevel(level);
		dept.setSort(sort);
		dept.setPath(path);
		ds.addDept(dept);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void modify(){
		String id = getPara("id");
		Dept dept = ds.findById(id);
		String pid = dept.getPid();
		
		String caption = getPara("caption");
		String summary = getPara("summary");
		Integer level = getParaToInt("level", 1);
		
		dept.setCaption(caption);
		dept.setSummary(summary);
		dept.setLevel(level);
		ds.modifyDept(dept);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void remove(){
		String compId = attr().getComp().getId();
		String pid = getPara("pid");
		String ids = getPara("ids");
		ds.removeDepts(compId, ids);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void sort(){
		String compId = attr().getComp().getId();
		String pid = getPara("pid");
		String opt = getPara("opt");
		String ids = getPara("ids");
		ds.sort(compId, pid, opt, ids);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
}
