package itez.plat.base;

import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager;

public class BaseConfig extends ModuleBase {
	
	public static final String MODULE_CODE = "plat";

	private String moduleCode = MODULE_CODE;
	private String modulePath = "/plat";
	private String moduleView = "base";
	private String moduleName = "主模块";

	public final static String SERVICE_UserIO = "userIoService";
	public final static String SERVICE_UserTm3 = "tm3Service";
	public final static String SERVICE_COMP_WX = "compWxService";
	public final static String SERVICE_COMP_BANK = "compBankService";
	public final static String SERVICE_ROLE = "roleService";
	public final static String SERVICE_PERM = "permService";
	public final static String SERVICE_POST = "postService";
	public final static String SERVICE_POST_LEVEL = "postLevelService";
	public final static String SERVICE_MODULE = "moduleService";
	public final static String SERVICE_VERT = "vertService";
	public final static String SERVICE_DEPT = "deptService";
	public final static String SERVICE_MENU = "menuService";
	public final static String SERVICE_CONFIG_GROUP = "configGroupService";
	public final static String SERVICE_CONFIG_DEFAULT = "configDefaultService";
	public final static String SERVICE_CONFIG = "configService";
	public final static String SERVICE_WX = "wxService";
	public final static String SERVICE_WXA_USER = "wxaUserService";
	public final static String SERVICE_QUEUE_TEST = "queueTestService"; //队列测试服务
	
	public BaseConfig(){
		//仅在默认模块中设置一次即可，其他模块配置文件中省略该行代码
		ModuleManager.me.setDefaultModuleCode(moduleCode);
	}

	@Override
	public String getModuleCode() {
		return moduleCode;
	}

	@Override
	public String getModuleName() {
		return moduleName;
	}

	@Override
	public String getModulePath() {
		return modulePath;
	}

	@Override
	public void setModulePath(String modulePath) {
		this.modulePath = modulePath;
	}

	@Override
	public String getModuleView() {
		return moduleView;
	}

	@Override
	public void setModuleView(String moduleView) {
		this.moduleView = moduleView;
	}

}
