define(['css', 'store', 'kit', 'ez-validator', 'icheck', 'select2', 'slider'], function(Css, Store, Kit, Vali){
	
	var service = {
		mySkins: ['skin-blue', 'skin-red', 'skin-yellow', 'skin-green']
	}
	
	service.changeSkin = function(cls){
		var me = this;
		$.each(me.mySkins, function (i) { $('body').removeClass(me.mySkins[i]) });
		$('body').addClass(cls);
		Store.set('JW_SKIN', cls);
		return false;
	}
	
	service.goodUi = function(){
		//初始化iCheck（iCheck在Vue环境下，使用v-model双向绑定时存在问题，暂时屏蔽）
		$("input[type='checkbox']").iCheck({ checkboxClass : "icheckbox_square-blue", increaseArea : "20%" });
		$("input[type='radio']").iCheck({ radioClass : "iradio_square-blue", increaseArea : "20%" });
		//初始化操作提示框
		$('[data-toggle="tooltip"]').tooltip();
		//使用select2插件
		$(".select2").select2();
		//使用slider插件
		$(".slider").slider({ id: 'blue', tooltip: 'always', tooltip_position:'bottom' });
	}
	
	service.setup = function(){
		var me = this;
		
		require(['css!' + ATTR.web + '/base/asset/css/plat']);
		
		//初始化页面主题
		var skin = Store.get("JW_SKIN");
		if(Kit.isEmpty(skin)) skin = "skin-blue";
		if (skin && $.inArray(skin, me.mySkins)) me.changeSkin(skin);
		$("[data-skin]").on("click", function (e) { e.preventDefault(); me.changeSkin($(this).data("skin")); })
		
		//初始化菜单显示
		var sidebarCls = 'sidebar-collapse';
		var sidebar = Store.get('JW_SIDEBAR');
		if(sidebar === 'open') $(document.body).removeClass(sidebarCls);
		$('.sidebar-toggle').on('click', function(){ Store.set('JW_SIDEBAR', $(document.body).hasClass(sidebarCls)? 'open' : 'close'); });
		
		//默认加载表单校验器
		Vali.bindFormVali();

		/*
		//改变窗口大小时，内容区自适应
		//$(window).on('resize', $.itez.charts.resize);
		*/
	};
	
	return service;
	
});
	  