/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.plugin;

import cn.com.fishin.tuz.core.Tuz;
import cn.com.fishin.tuz.entity.FTPUploadFile;
import cn.com.fishin.tuz.entity.LoginInfo;
import cn.com.fishin.tuz.factory.FTPUploadFileFactory;
import cn.com.fishin.tuz.helper.FTPHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class NetPlugin {
    public static boolean uploadToServer(FTPUploadFile file) throws IOException {
        return FTPHelper.upload(file, Tuz.getConfig().getFtpControlEncoding());
    }

    public static boolean uploadBinaryToServer(LoginInfo loginInfo, String remoteDirection, String remoteFileName, InputStream inputStream) throws IOException {
        FTPUploadFile file = FTPUploadFileFactory.makeBinaryFile(remoteDirection, remoteFileName, inputStream);
        file.setLoginInfo(loginInfo);
        return NetPlugin.uploadToServer(file);
    }

    public static boolean uploadBinaryToServer(String remoteDirection, String remoteFileName, InputStream inputStream) throws IOException {
        return NetPlugin.uploadBinaryToServer(new LoginInfo(Tuz.getConfig().getFtpUser(), Tuz.getConfig().getFtpPassword()), remoteDirection, remoteFileName, inputStream);
    }

    public static boolean uploadTextToServer(LoginInfo loginInfo, String remoteDirection, String remoteFileName, InputStream inputStream, Charset charset) throws IOException {
        FTPUploadFile file = FTPUploadFileFactory.makeAsciiFile(remoteDirection, remoteFileName, inputStream);
        file.setLoginInfo(loginInfo);
        file.setCharset(charset);
        return NetPlugin.uploadToServer(file);
    }

    public static boolean uploadTextToServer(LoginInfo loginInfo, String remoteDirection, String remoteFileName, InputStream inputStream) throws IOException {
        FTPUploadFile file = FTPUploadFileFactory.makeAsciiFile(remoteDirection, remoteFileName, inputStream);
        file.setLoginInfo(loginInfo);
        return NetPlugin.uploadToServer(file);
    }
}

