/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.plugin;

import cn.com.fishin.tuz.core.Tuz;
import cn.com.fishin.tuz.helper.ClassHelper;
import cn.com.fishin.tuz.helper.LogHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DiPlugin {
    private static final Map<String, Object> instances = new ConcurrentHashMap<String, Object>(32);
    private static final Lock newInstanceLock = new ReentrantLock();

    public static <T> T useInstance(Class<T> classType, boolean singleton) {
        return DiPlugin.useInstance(classType.getSimpleName(), classType, singleton);
    }

    public static <T> T useInstance(Class<T> classType) {
        return DiPlugin.useInstance(classType, Tuz.getConfig().isSingleton());
    }

    public static <T> T useInstance(String key, Class<T> classType, boolean singleton) {
        return DiPlugin.useInstanceInternal(Tuz.useGracefully(key, ""), classType, singleton);
    }

    public static <T> T useInstance(String key, Class<T> classType) {
        return DiPlugin.useInstance(key, classType, Tuz.getConfig().isSingleton());
    }

    public static <T> T useInstance(String key, String namespace, Class<T> classType, boolean singleton) {
        return DiPlugin.useInstanceInternal(Tuz.useGracefully(key, namespace, ""), classType, singleton);
    }

    public static <T> T useInstance(String key, String namespace, Class<T> classType) {
        return DiPlugin.useInstance(key, namespace, classType, Tuz.getConfig().isSingleton());
    }

    private static <T> T singletonInstance(String className, Class<T> classType) {
        newInstanceLock.lock();
        try {
            if (!instances.containsKey(classType.getName())) {
                T t = ClassHelper.newInstance(className, classType);
                LogHelper.info("Instance created ===> " + classType.getName());
                instances.put(classType.getName(), t);
            }
        }
        finally {
            newInstanceLock.unlock();
        }
        return (T)instances.get(classType.getName());
    }

    private static <T> T useInstanceInternal(String className, Class<T> classType, boolean singleton) {
        if (singleton) {
            return DiPlugin.singletonInstance(className, classType);
        }
        LogHelper.info("Instance created ===> " + classType.getName());
        return ClassHelper.newInstance(className, classType);
    }
}

