/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.helper;

import cn.com.fishin.tuz.entity.FTPUploadFile;
import cn.com.fishin.tuz.entity.LoginInfo;
import cn.com.fishin.tuz.entity.ServerAddress;
import cn.com.fishin.tuz.helper.LogHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.net.ftp.FTPClient;

public class FTPHelper {
    public static boolean upload(final FTPUploadFile file, final String controlEncoding) throws IOException {
        return new FTPTemplate(file.getServerAddress(), file.getLoginInfo()){

            @Override
            protected boolean upload(FTPClient client) throws IOException {
                client.setFileType(file.getFileType());
                client.setControlEncoding(controlEncoding);
                String direction = FTPHelper.encode(file.getRemoteDirection(), controlEncoding);
                if (!client.changeWorkingDirectory(direction)) {
                    client.makeDirectory(direction);
                    client.changeWorkingDirectory(direction);
                }
                return client.storeFile(FTPHelper.encode(file.getRemoteFileName(), controlEncoding), file.getInputStream());
            }
        }.upload();
    }

    public static boolean uploadAscii(FTPUploadFile file, String controlEncoding) throws IOException {
        file.setFileType(0);
        return FTPHelper.upload(file, controlEncoding);
    }

    public static boolean uploadBinary(FTPUploadFile file, String controlEncoding) throws IOException {
        file.setFileType(2);
        return FTPHelper.upload(file, controlEncoding);
    }

    public static FTPClient connectToFTP(ServerAddress address, LoginInfo user) throws IOException {
        FTPClient client = new FTPClient();
        client.connect(address.getIp(), address.getPort());
        client.login(user.getUsername(), user.getPassword());
        return client;
    }

    public static void disconnectFromFTP(FTPClient client) {
        try {
            client.logout();
            client.disconnect();
        }
        catch (IOException e) {
            LogHelper.error("Failed to disconnect from FTP server!" + client, e);
        }
    }

    private static String encode(String str, String encoding) throws UnsupportedEncodingException {
        return new String(str.getBytes(encoding), "ISO-8859-1");
    }

    private static abstract class FTPTemplate {
        private FTPClient client = null;

        FTPTemplate(ServerAddress address, LoginInfo info) {
            try {
                this.client = FTPHelper.connectToFTP(address, info);
            }
            catch (IOException e) {
                String errorMessage = "Failed to connect to FTP server at [" + address.getIp() + ":" + address.getPort() + "], user is " + info.getUsername() + ", password is " + info.getPassword();
                LogHelper.error(errorMessage, e);
                throw new RuntimeException(errorMessage, e);
            }
        }

        protected abstract boolean upload(FTPClient var1) throws IOException;

        boolean upload() throws IOException {
            try {
                boolean bl = this.upload(this.client);
                return bl;
            }
            finally {
                FTPHelper.disconnectFromFTP(this.client);
            }
        }
    }
}

