/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.helper;

import cn.com.fishin.tuz.helper.LogHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public class ClassHelper {
    public static Object newInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        ClassHelper.checkConstructor(className, constructor);
        return constructor.newInstance(new Object[0]);
    }

    private static void checkConstructor(String className, Constructor constructor) throws NoSuchMethodException {
        if (constructor == null) {
            throw new NoSuchMethodException("Non-parameter constructor is not found in class " + className + " !");
        }
        constructor.setAccessible(true);
    }

    public static <T> T newInstance(String className, Class<T> classType) {
        try {
            return (T)ClassHelper.newInstance(className);
        }
        catch (ClassNotFoundException e) {
            LogHelper.error("The class [" + className + "] is not found!", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LogHelper.error("The class [" + className + "] is not allowed to access!", e);
        }
        catch (InstantiationException | NoSuchMethodException e) {
            LogHelper.error("Non-parameter constructor is not found in class [" + className + "]!", e);
        }
        return null;
    }

    public static Class<?> classOf(Object obj) {
        return obj.getClass();
    }

    public static ClassLoader classLoaderOf(Object obj) {
        return ClassHelper.classOf(obj).getClassLoader();
    }

    public static Class<?>[] interfacesOf(Object obj) {
        return ClassHelper.classOf(obj).getInterfaces();
    }

    public static boolean hasInterface(Object obj) {
        return ClassHelper.interfacesOf(obj).length > 0;
    }

    public static boolean isFinal(Object obj) {
        return Modifier.isFinal(ClassHelper.classOf(obj).getModifiers());
    }
}

