/*
 * Decompiled with CFR 0.152.
 */
package cn.com.fishin.tuz.core;

import cn.com.fishin.tuz.core.Loadable;
import cn.com.fishin.tuz.core.TuzConfig;
import cn.com.fishin.tuz.helper.LogHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Tuz {
    private static final Map<String, Map<String, String>> resources = new HashMap<String, Map<String, String>>();
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final Lock readLock = readWriteLock.readLock();
    private static final Lock writeLock = readWriteLock.writeLock();
    private static TuzConfig config = new TuzConfig();

    public static TuzConfig getConfig() {
        return config;
    }

    public static void setConfig(TuzConfig config) {
        Tuz.config = config;
    }

    public static void load(Loadable resource) throws IOException {
        writeLock.lock();
        try {
            resources.put(resource.namespace(), resource.load());
        }
        finally {
            writeLock.unlock();
        }
        LogHelper.debug("Namespace [" + resource.namespace() + "] is loaded!");
    }

    public static void unLoad(Loadable resource) {
        Tuz.unLoad(resource.namespace());
    }

    public static void unLoad(String namespace) {
        writeLock.lock();
        try {
            resources.remove(namespace);
        }
        finally {
            writeLock.unlock();
        }
        LogHelper.debug("Namespace [" + namespace + "] is unloaded!");
    }

    public static void reLoad(Loadable resource) throws IOException {
        writeLock.lock();
        try {
            resources.put(resource.namespace(), resource.load());
        }
        finally {
            writeLock.unlock();
        }
        LogHelper.debug("Namespace [" + resource.namespace() + "] is reloaded!");
    }

    public static String use(String key, String namespace) {
        return Tuz.useGracefully(key, namespace, null);
    }

    public static String unUse(String key, String namespace) {
        writeLock.lock();
        try {
            String string = resources.containsKey(namespace) ? resources.get(namespace).remove(key) : null;
            return string;
        }
        finally {
            writeLock.unlock();
        }
    }

    public static void appendResource(Map<String, String> resource, String namespace) {
        writeLock.lock();
        try {
            if (resources.containsKey(namespace)) {
                resources.get(namespace).putAll(resource);
                LogHelper.debug("Resource " + resource + " is appended to namespace [ " + namespace + " ] !");
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public static void appendResource(String key, String value, String namespace) {
        writeLock.lock();
        try {
            if (resources.containsKey(namespace)) {
                resources.get(namespace).put(key, value);
                LogHelper.debug("Resource {" + key + "=" + value + "} is appended to namespace [ " + namespace + " ] !");
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String useGracefully(String key, String namespace, String defaultValue) {
        readLock.lock();
        try {
            String string = resources.containsKey(namespace) ? resources.get(namespace).get(key) : defaultValue;
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    public static String use(String key) {
        return Tuz.useGracefully(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String useGracefully(String key, String defaultValue) {
        readLock.lock();
        try {
            for (String namespace : resources.keySet()) {
                Map<String, String> resource = resources.get(namespace);
                if (!resource.containsKey(key)) continue;
                String string = resource.get(key);
                return string;
            }
            String string = defaultValue;
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    public static void init() {
        writeLock.lock();
        try {
            config = new TuzConfig();
        }
        finally {
            writeLock.unlock();
        }
    }
}

