/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinarecrm.rop.server;

import cn.com.chinarecrm.rop.core.signer.AppsecretFetcher;
import cn.com.chinarecrm.rop.core.signer.DigestSigner;
import cn.com.chinarecrm.rop.core.signer.Signer;
import cn.com.chinarecrm.rop.server.ROPException;
import cn.com.chinarecrm.rop.server.RequestChecker;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class ROPSignInterceptor {
    @Autowired
    RequestChecker checker;
    String digestName;
    @Autowired
    AppsecretFetcher fetcher;
    @Autowired
    HttpServletRequest request;
    @Autowired
    HttpServletResponse response;
    Signer signer;

    public ROPSignInterceptor(String digestName) {
        this.digestName = digestName;
        this.signer = new DigestSigner(digestName);
    }

    @Around(value="@within(cn.com.chinarecrm.rop.server.RopController)|| @annotation(cn.com.chinarecrm.rop.server.RopController)")
    public Object filter(ProceedingJoinPoint point) throws Throwable {
        if (this.checker.check(this.request) && this.signer.check(this.request, this.fetcher)) {
            return point.proceed();
        }
        throw new ROPException("checkSign failed");
    }
}

