/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinarecrm.rop.server;

import cn.com.chinarecrm.rop.config.ROPServerConfigurationProperties;
import cn.com.chinarecrm.rop.core.signer.AppsecretFetcher;
import cn.com.chinarecrm.rop.core.signer.DigestSigner;
import cn.com.chinarecrm.rop.server.RopController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Lang;
import org.nutz.lang.Times;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice(annotations={RopController.class})
public class ROPResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    AppsecretFetcher appsecretFetcher;
    String digestName;
    @Autowired
    HttpServletRequest request;
    @Autowired
    HttpServletResponse response;

    public ROPResponseBodyAdvice(ROPServerConfigurationProperties properties) {
        this.digestName = properties.getDigestName();
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest req, ServerHttpResponse resp) {
        HttpMessageConverters messageConverters = (HttpMessageConverters)this.applicationContext.getBean(HttpMessageConverters.class);
        HttpMessageConverter messageConverter = null;
        for (HttpMessageConverter httpMessageConverter : messageConverters) {
            if (httpMessageConverter.getClass() != selectedConverterType) continue;
            messageConverter = httpMessageConverter;
            break;
        }
        if (messageConverter == null) {
            throw Lang.makeThrow((String)"messageConverter of type %s can't found!", (Object[])new Object[]{selectedConverterType.getName()});
        }
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            messageConverter.write(body, selectedContentType, new HttpOutputMessage(){

                public OutputStream getBody() throws IOException {
                    return baos;
                }

                public HttpHeaders getHeaders() {
                    return new HttpHeaders();
                }
            });
        }
        catch (IOException | RuntimeException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
        String bodyMd5 = Lang.md5((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        String key = this.request.getHeader("rop-sign-appkey");
        String gateway = this.request.getHeader("rop-service-method");
        String timestamp = Times.now().getTime() + "";
        String nonce = this.request.getHeader("rop-nonce");
        String sign = new DigestSigner(this.digestName).sign(this.appsecretFetcher.fetch(key), timestamp, gateway, nonce, bodyMd5);
        this.response.setHeader("rop-ts", timestamp);
        this.response.setHeader("rop-sign", sign);
        return body;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }
}

