/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinarecrm.rop.config;

import cn.com.chinarecrm.rop.config.ROPServerConfigurationProperties;
import cn.com.chinarecrm.rop.core.signer.AppsecretFetcher;
import cn.com.chinarecrm.rop.core.signer.DefaultMD5Fetcher;
import cn.com.chinarecrm.rop.server.NullRequestChecker;
import cn.com.chinarecrm.rop.server.ROPExceptionHandler;
import cn.com.chinarecrm.rop.server.ROPResponseBodyAdvice;
import cn.com.chinarecrm.rop.server.ROPServlet;
import cn.com.chinarecrm.rop.server.ROPSignInterceptor;
import cn.com.chinarecrm.rop.server.RequestChecker;
import cn.com.chinarecrm.rop.server.ResettableStreamHttpServletRequest;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.MultipartResolver;

@Configuration
@EnableConfigurationProperties(value={ROPServerConfigurationProperties.class})
public class ROPServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AppsecretFetcher.class})
    public AppsecretFetcher appsecretFetcher() {
        return new DefaultMD5Fetcher();
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean(ROPServerConfigurationProperties properties, final MultipartResolver multipartResolver) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(new Filter(){

            public void destroy() {
            }

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                ResettableStreamHttpServletRequest requestWrapper = null;
                if (request instanceof HttpServletRequest) {
                    requestWrapper = new ResettableStreamHttpServletRequest((HttpServletRequest)request);
                }
                if (requestWrapper == null || multipartResolver.isMultipart((HttpServletRequest)request)) {
                    chain.doFilter(request, response);
                } else {
                    chain.doFilter((ServletRequest)requestWrapper, response);
                }
            }
        });
        registration.addUrlPatterns(new String[]{properties.getRopPath()});
        registration.setOrder(1);
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean(value={RequestChecker.class})
    public RequestChecker requestChecker() {
        return new NullRequestChecker();
    }

    @Bean
    @ConditionalOnMissingBean(value={ROPResponseBodyAdvice.class})
    public ROPResponseBodyAdvice responseBodyAdvice(ROPServerConfigurationProperties properties) {
        return new ROPResponseBodyAdvice(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={ROPExceptionHandler.class})
    public ROPExceptionHandler ropExceptionHandler() {
        return new ROPExceptionHandler();
    }

    @Bean
    public ROPSignInterceptor ropSignInterceptor(ROPServerConfigurationProperties properties) {
        return new ROPSignInterceptor(properties.getDigestName());
    }

    @Bean
    public ServletRegistrationBean servletRegistrationBean(ROPServerConfigurationProperties properties, MultipartConfigElement multipartConfigFactory) {
        ServletRegistrationBean ropServletRegistrationBean = new ServletRegistrationBean((Servlet)new ROPServlet(), new String[0]);
        ropServletRegistrationBean.addUrlMappings(new String[]{properties.getRopPath()});
        ropServletRegistrationBean.setMultipartConfig(multipartConfigFactory);
        NutMap initParameters = NutMap.NEW().setv("timeout", (Object)("" + properties.getTimeout()));
        if (Strings.isNotBlank((CharSequence)properties.getGateWayUri())) {
            initParameters.setv("gateWayUri", (Object)properties.getGateWayUri());
        }
        ropServletRegistrationBean.setInitParameters((Map)initParameters);
        return ropServletRegistrationBean;
    }
}

