/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinarecrm.rop.core.signer;

import cn.com.chinarecrm.rop.core.signer.AppsecretFetcher;
import cn.com.chinarecrm.rop.core.signer.Signer;
import cn.com.chinarecrm.rop.core.signer.SignerHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.nutz.http.Http;
import org.nutz.http.Response;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class AbstractSigner
implements Signer {
    Log log = Logs.get();

    @Override
    public boolean check(HttpServletRequest request, AppsecretFetcher fetcher) {
        if (Strings.isBlank((CharSequence)request.getHeader("rop-sign-appkey")) || Strings.isBlank((CharSequence)request.getHeader("rop-ts")) || Strings.isBlank((CharSequence)request.getHeader("rop-service-method")) || Strings.isBlank((CharSequence)request.getHeader("rop-nonce")) || Strings.isBlank((CharSequence)request.getHeader("rop-sign"))) {
            return false;
        }
        String sign = request.getHeader("rop-sign");
        this.log.debugf("Expected sign is %s", new Object[]{sign});
        return Strings.equalsIgnoreCase((String)this.sign(request, fetcher), (String)sign);
    }

    @Override
    public boolean check(Response response, String appSecret, String nonce, String gateway) {
        String timestamp = response.getHeader().get("rop-ts");
        String sign = response.getHeader().get("rop-sign");
        return Strings.equals((String)this.sign(appSecret, timestamp, gateway, nonce, Lang.md5((CharSequence)response.getContent())), (String)sign);
    }

    public String contentType(HttpServletRequest request) {
        return request.getHeader("Content-Type");
    }

    protected String getDataMate(HttpServletRequest request) {
        if (Strings.equalsIgnoreCase((String)request.getMethod(), (String)"GET")) {
            return Lang.md5((CharSequence)Http.encode((Object)request.getQueryString(), (String)request.getCharacterEncoding()));
        }
        if (this.isFileUpload(request)) {
            try {
                return Lang.md5((InputStream)new ByteArrayInputStream(this.getUrlEncodedParams(request).getBytes(request.getCharacterEncoding())));
            }
            catch (IOException | ServletException e) {
                this.log.debug((Object)"\u4e0d\u652f\u6301\u7684\u7f16\u7801!");
                throw Lang.wrapThrow((Throwable)e);
            }
        }
        try {
            StringBuilder info = Streams.read((Reader)new InputStreamReader((InputStream)request.getInputStream()));
            if (info.length() == 0) {
                return Lang.md5((CharSequence)SignerHelper.paramMapAsUrlString(request.getParameterMap(), request.getCharacterEncoding()));
            }
            return Lang.md5((CharSequence)info);
        }
        catch (IOException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
    }

    public String getUrlEncodedParams(HttpServletRequest request) throws IOException, ServletException {
        StringBuilder sb = new StringBuilder();
        List parts = Lang.collection2list((Collection)request.getParts());
        Collections.sort(parts, (part1, part2) -> part1.getName().compareTo(part2.getName()));
        parts.stream().forEach(part -> {
            String key = part.getName();
            if (Strings.isBlank((CharSequence)part.getContentType())) {
                sb.append(Http.encode((Object)key, (String)request.getCharacterEncoding())).append('=').append(Http.encode((Object)request.getParameter(key), (String)request.getCharacterEncoding())).append('&');
            } else {
                try {
                    sb.append(Http.encode((Object)key, (String)request.getCharacterEncoding())).append('=').append(Http.encode((Object)Lang.md5((InputStream)part.getInputStream()), (String)request.getCharacterEncoding())).append('&');
                }
                catch (IOException e) {
                    throw Lang.wrapThrow((Throwable)e);
                }
            }
        });
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private boolean isCommonFileUpload(HttpServletRequest request) {
        return this.contentType(request) != null && this.contentType(request).startsWith("multipart/form-data");
    }

    private boolean isFileUpload(HttpServletRequest request) {
        return this.isCommonFileUpload(request) || this.isHtml5FileUpload(request);
    }

    private boolean isHtml5FileUpload(HttpServletRequest request) {
        return this.contentType(request) != null && this.contentType(request).startsWith("application/octet-stream");
    }

    public String sign(AppsecretFetcher fetcher, String appKey, String timestamp, String gateway, String nonce, String dataMate) {
        return this.sign(fetcher.fetch(appKey), timestamp, gateway, nonce, dataMate);
    }

    public String sign(HttpServletRequest request, AppsecretFetcher fetcher) {
        return this.sign(fetcher, request.getHeader("rop-sign-appkey"), request.getHeader("rop-ts"), request.getHeader("rop-service-method"), request.getHeader("rop-nonce"), this.getDataMate(request));
    }
}

