/*
 * Decompiled with CFR 0.152.
 */
package cn.com.chinarecrm.rop.core;

import cn.com.chinarecrm.rop.core.OperationState;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;

public class ROPResponse<T> {
    private T data;
    private String msg;
    private OperationState operationState = OperationState.DEFAULT;

    public static ROPResponse exception() {
        return ROPResponse.me().setOperationState(OperationState.EXCEPTION);
    }

    public static ROPResponse exception(Exception e) {
        return ROPResponse.exception(e.getMessage());
    }

    public static ROPResponse exception(String msg) {
        return ROPResponse.exception().setMsg(msg);
    }

    public static ROPResponse fail(String reason) {
        return ROPResponse.me().setOperationState(OperationState.FAIL).setMsg(reason);
    }

    public static ROPResponse me() {
        return new ROPResponse();
    }

    public static ROPResponse success() {
        return ROPResponse.me().setOperationState(OperationState.SUCCESS);
    }

    public static ROPResponse unlogin() {
        return ROPResponse.me().setOperationState(OperationState.UNLOGINED);
    }

    public T getData() {
        return this.data;
    }

    public String getMsg() {
        return this.msg;
    }

    public OperationState getOperationState() {
        return this.operationState;
    }

    public boolean isSuccess() {
        return this.getOperationState() == OperationState.SUCCESS;
    }

    public ROPResponse<T> setData(T data) {
        this.data = data;
        return this;
    }

    public ROPResponse setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public ROPResponse setOperationState(OperationState operationState) {
        this.operationState = operationState;
        return this;
    }

    public ROPResponse<T> success(T t) {
        return ROPResponse.success().setData(t);
    }

    public String toString() {
        return Json.toJson((Object)this, (JsonFormat)JsonFormat.forLook());
    }
}

