/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.rop.client;

import com.chinare.rop.core.signer.SignerHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nutz.http.Cookie;
import org.nutz.http.Header;
import org.nutz.http.Http;
import org.nutz.http.Request;
import org.nutz.json.Json;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.util.NutMap;

public class ROPRequest {
    private byte[] data;
    private String enc = "UTF-8";
    private String gateway;
    private Header header;
    private InputStream inputStream;
    private Request.METHOD method;
    private Map<String, Object> params;

    public static ROPRequest create(String gateway, Request.METHOD method) {
        return ROPRequest.create(gateway, method, new HashMap<String, Object>());
    }

    public static ROPRequest create(String gateway, Request.METHOD method, Map<String, Object> params) {
        return ROPRequest.create(gateway, method, params, Header.create());
    }

    public static ROPRequest create(String gateway, Request.METHOD method, Map<String, Object> params, Header header) {
        return new ROPRequest().setMethod(method).setParams(params).setGateway(gateway).setHeader(header);
    }

    public static ROPRequest create(String gateway, Request.METHOD method, String paramsAsJson) {
        return ROPRequest.create(gateway, method, (Map)Json.fromJson((CharSequence)paramsAsJson));
    }

    public static ROPRequest create(String gateway, Request.METHOD method, String paramsAsJson, Header header) {
        return ROPRequest.create(gateway, method, (Map)Json.fromJson((CharSequence)paramsAsJson), header);
    }

    public static ROPRequest get(String gateway) {
        return ROPRequest.create(gateway, Request.METHOD.GET, new HashMap<String, Object>());
    }

    public static ROPRequest get(String gateway, Header header) {
        return ROPRequest.create(gateway, Request.METHOD.GET, new HashMap<String, Object>(), header);
    }

    public static ROPRequest post(String gateway) {
        return ROPRequest.create(gateway, Request.METHOD.POST, new HashMap<String, Object>());
    }

    public static ROPRequest post(String gateway, Header header) {
        return ROPRequest.create(gateway, Request.METHOD.POST, new HashMap<String, Object>(), header);
    }

    private ROPRequest() {
    }

    protected void fileUpload(final StringBuilder sb) {
        ArrayList<String> keys = new ArrayList<String>(this.params.keySet());
        Collections.sort(keys);
        for (final String key : keys) {
            Object val = this.params.get(key);
            if (val == null) {
                val = "";
            }
            Lang.each((Object)val, (Each)new Each<Object>(){

                public void invoke(int index, Object ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                    if (ele instanceof File) {
                        sb.append(Http.encode((Object)key, (String)ROPRequest.this.enc)).append('=').append(Http.encode((Object)Lang.md5((File)((File)ele)), (String)ROPRequest.this.enc)).append('&');
                    } else {
                        sb.append(Http.encode((Object)key, (String)ROPRequest.this.enc)).append('=').append(Http.encode((Object)ele, (String)ROPRequest.this.enc)).append('&');
                    }
                }
            });
        }
    }

    public Cookie getCookie() {
        String s = this.header.get("Cookie");
        if (null == s) {
            return new Cookie();
        }
        return new Cookie(s);
    }

    public byte[] getData() {
        return this.data;
    }

    public String getEnc() {
        return this.enc;
    }

    public String getGateway() {
        return this.gateway;
    }

    public Header getHeader() {
        return this.header;
    }

    public InputStream getInputStream() {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.header.get("Content-Type") == null) {
            this.header.asFormContentType(this.enc);
        }
        if (null == this.data) {
            try {
                return new ByteArrayInputStream(this.getUrlEncodedParams().getBytes(this.enc));
            }
            catch (UnsupportedEncodingException e) {
                throw Lang.wrapThrow((Throwable)e);
            }
        }
        return new ByteArrayInputStream(this.data);
    }

    public Request.METHOD getMethod() {
        return this.method;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getUrlEncodedParams() {
        StringBuilder sb = new StringBuilder();
        if (this.isFileUpload()) {
            this.fileUpload(sb);
        } else if (this.params != null) {
            return SignerHelper.mapAsUrlParams(this.params, (String)this.enc);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public ROPRequest header(String key, String value) {
        this.getHeader().set(key, value);
        return this;
    }

    public boolean isDelete() {
        return Request.METHOD.DELETE == this.method;
    }

    public boolean isFileUpload() {
        final NutMap t = NutMap.NEW().addv("target", (Object)false);
        if ((this.isPost() || this.isPut()) && this.getParams() != null) {
            for (Object val : this.getParams().values()) {
                Lang.each((Object)val, (Each)new Each<Object>(){

                    public void invoke(int index, Object ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                        if (ele instanceof File) {
                            t.put((Object)"target", (Object)true);
                            throw new ExitLoop();
                        }
                    }
                });
            }
        }
        return t.getBoolean("target");
    }

    public boolean isGet() {
        return Request.METHOD.GET == this.method;
    }

    public boolean isPost() {
        return Request.METHOD.POST == this.method;
    }

    public boolean isPut() {
        return Request.METHOD.PUT == this.method;
    }

    public ROPRequest setCookie(Cookie cookie) {
        this.header.set("Cookie", cookie.toString());
        return this;
    }

    public ROPRequest setData(byte[] data) {
        this.data = data;
        return this;
    }

    public ROPRequest setData(String data) {
        this.data = data.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public ROPRequest setEnc(String reqEnc) {
        if (reqEnc != null) {
            this.enc = reqEnc;
        }
        return this;
    }

    public ROPRequest setGateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    public ROPRequest setHeader(Header header) {
        if (header == null) {
            header = Header.create();
        }
        this.header = header;
        return this;
    }

    public ROPRequest setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public ROPRequest setMethod(Request.METHOD method) {
        this.method = method;
        return this;
    }

    public ROPRequest setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }
}

