/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.rop.client;

import com.chinare.rop.client.ClientSigner;
import com.chinare.rop.client.ROPClientDigestSigner;
import com.chinare.rop.client.ROPRequest;
import java.net.Proxy;
import java.util.stream.Collectors;
import org.nutz.http.Header;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Times;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class ROPClient {
    private String appKey;
    private String appSecret;
    private String digestName;
    private String endpoint;
    Log log = Logs.get();
    Proxy proxy;
    ClientSigner signer;

    public static ROPClient create(String appKey, String appSecret, String endpoint, String digestName) {
        ROPClient client = new ROPClient();
        client.setAppKey(appKey);
        client.setAppSecret(appSecret);
        client.setEndpoint(endpoint);
        client.setDigestName(digestName);
        client.setSigner(new ROPClientDigestSigner(digestName));
        return client;
    }

    private ROPClient() {
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getDigestName() {
        return this.digestName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public ClientSigner getSigner() {
        return this.signer;
    }

    public Response send(ROPRequest request) {
        Response response = this.proxy != null ? Sender.create((Request)this.toRequest(request)).setProxy(this.proxy).send() : Sender.create((Request)this.toRequest(request)).send();
        if (!response.isOK()) {
            throw Lang.makeThrow((String)"\u8bf7\u6c42\u5931\u8d25,\u72b6\u6001\u7801:%d", (Object[])new Object[]{response.getStatus()});
        }
        if (this.log.isDebugEnabled()) {
            Header header = response.getHeader();
            this.log.debugf("response headers -> %s", new Object[]{Json.toJson(header.getAll().stream().map(item -> NutMap.NEW().addv("key", item.getKey()).addv("value", item.getValue())).collect(Collectors.toList()))});
        }
        if (this.signer.check(response, this.appSecret, request.getHeader().get("rop-nonce"), request.getGateway())) {
            return response;
        }
        throw Lang.makeThrow((String)"\u54cd\u5e94\u7b7e\u540d\u68c0\u67e5\u5931\u8d25!", (Object[])new Object[0]);
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setDigestName(String digestName) {
        this.digestName = digestName;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setSigner(ClientSigner signer) {
        this.signer = signer;
    }

    private Header signHeader(ROPRequest request) {
        String nonce = R.UU16();
        String ts = Times.now().getTime() + "";
        Header header = request.getHeader().set("rop-sign-appkey", this.appKey).set("rop-service-method", request.getGateway()).set("rop-nonce", nonce).set("rop-ts", ts).set("rop-sign", this.signer.sign(this.appSecret, ts, request.getGateway(), nonce, request));
        return request.getData() == null || request.getData().length == 0 ? header.asFormContentType() : header.asJsonContentType();
    }

    public Request toRequest(ROPRequest request) {
        Request req = Request.create((String)this.endpoint, (Request.METHOD)request.getMethod());
        req.setParams(request.getParams());
        req.setData(request.getData());
        req.setHeader(this.signHeader(request));
        Header header = req.getHeader();
        this.log.debugf("send headers %s", new Object[]{header});
        return req;
    }
}

