/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class Ips {
    private static final int INADDR4SZ = 4;

    private Ips() {
    }

    public static boolean internalIp(String ip) {
        byte[] addr = Ips.textToNumericFormatV4(ip);
        return Ips.internalIp(addr);
    }

    public static byte[] textToNumericFormatV4(String src) {
        byte[] nullbyte = new byte[]{};
        if (src.length() == 0) {
            return nullbyte;
        }
        byte[] res = new byte[4];
        String[] s = src.split("\\.", -1);
        try {
            switch (s.length) {
                case 1: {
                    return Ips.case1(nullbyte, res, s);
                }
                case 2: {
                    return Ips.case2(nullbyte, res, s);
                }
                case 3: {
                    return Ips.case3(nullbyte, res, s);
                }
                case 4: {
                    return Ips.case4(nullbyte, res, s);
                }
            }
            return nullbyte;
        }
        catch (NumberFormatException e) {
            return nullbyte;
        }
    }

    private static byte[] case4(byte[] nullbyte, byte[] res, String[] s) {
        for (int i = 0; i < 4; ++i) {
            long val = Integer.parseInt(s[i]);
            if (val < 0L || val > 255L) {
                return nullbyte;
            }
            res[i] = (byte)(val & 0xFFL);
        }
        return res;
    }

    private static byte[] case3(byte[] nullbyte, byte[] res, String[] s) {
        long val;
        for (int i = 0; i < 2; ++i) {
            val = Integer.parseInt(s[i]);
            if (val < 0L || val > 255L) {
                return nullbyte;
            }
            res[i] = (byte)(val & 0xFFL);
        }
        val = Integer.parseInt(s[2]);
        if (val < 0L || val > 65535L) {
            return nullbyte;
        }
        res[2] = (byte)(val >> 8 & 0xFFL);
        res[3] = (byte)(val & 0xFFL);
        return res;
    }

    private static byte[] case2(byte[] nullbyte, byte[] res, String[] s) {
        long val = Integer.parseInt(s[0]);
        if (val < 0L || val > 255L) {
            return nullbyte;
        }
        res[0] = (byte)(val & 0xFFL);
        val = Integer.parseInt(s[1]);
        if (val < 0L || val > 0xFFFFFFL) {
            return nullbyte;
        }
        res[1] = (byte)(val >> 16 & 0xFFL);
        res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
        res[3] = (byte)(val & 0xFFL);
        return res;
    }

    private static byte[] case1(byte[] nullbyte, byte[] res, String[] s) {
        long val = Long.parseLong(s[0]);
        if (val < 0L || val > 0xFFFFFFFFL) {
            return nullbyte;
        }
        res[0] = (byte)(val >> 24 & 0xFFL);
        res[1] = (byte)((val & 0xFFFFFFL) >> 16 & 0xFFL);
        res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
        res[3] = (byte)(val & 0xFFL);
        return res;
    }

    public static boolean internalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                return b1 >= 16 && b1 <= 31;
            }
            case -64: {
                return b1 == -88;
            }
        }
        return false;
    }

    public static String hostIp() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }
}

