/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.nutz.lang.Files;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class FileZipUtils {
    static final Log logger = Logs.get();

    private FileZipUtils() {
    }

    private static void zipFile(ZipOutputStream zipOutputStream, File file, String parentFileName) {
        try (FileInputStream in = new FileInputStream(file);){
            int len;
            ZipEntry zipEntry = new ZipEntry(parentFileName);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) != -1) {
                zipOutputStream.write(buf, 0, len);
            }
            zipOutputStream.closeEntry();
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
    }

    private static void directory(ZipOutputStream zipOutputStream, File file, String parentFileName) {
        File[] files = file.listFiles();
        String parentFileNameTemp = null;
        for (File fileTemp : files) {
            String string = parentFileNameTemp = Strings.isEmpty((CharSequence)parentFileName) ? fileTemp.getName() : parentFileName + File.separatorChar + fileTemp.getName();
            if (fileTemp.isDirectory()) {
                FileZipUtils.directory(zipOutputStream, fileTemp, parentFileNameTemp);
                continue;
            }
            FileZipUtils.zipFile(zipOutputStream, fileTemp, parentFileNameTemp);
        }
    }

    public static void zipFiles(File file, String destit) {
        FileZipUtils.zipFiles(file, Files.createFileIfNoExists2((String)destit));
    }

    public static void zipFiles(File file, File destit) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(destit);
             ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
            if (file.isDirectory()) {
                FileZipUtils.directory(zipOutputStream, file, "");
            } else {
                FileZipUtils.zipFile(zipOutputStream, file, "");
            }
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
    }
}

