/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.jsr380.validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.regex.Pattern;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class IdcardUtils {
    protected static String[][] codeAndCity = new String[][]{{"11", "\u5317\u4eac"}, {"12", "\u5929\u6d25"}, {"13", "\u6cb3\u5317"}, {"14", "\u5c71\u897f"}, {"15", "\u5185\u8499\u53e4"}, {"21", "\u8fbd\u5b81"}, {"22", "\u5409\u6797"}, {"23", "\u9ed1\u9f99\u6c5f"}, {"31", "\u4e0a\u6d77"}, {"32", "\u6c5f\u82cf"}, {"33", "\u6d59\u6c5f"}, {"34", "\u5b89\u5fbd"}, {"35", "\u798f\u5efa"}, {"36", "\u6c5f\u897f"}, {"37", "\u5c71\u4e1c"}, {"41", "\u6cb3\u5357"}, {"42", "\u6e56\u5317"}, {"43", "\u6e56\u5357"}, {"44", "\u5e7f\u4e1c"}, {"45", "\u5e7f\u897f"}, {"46", "\u6d77\u5357"}, {"50", "\u91cd\u5e86"}, {"51", "\u56db\u5ddd"}, {"52", "\u8d35\u5dde"}, {"53", "\u4e91\u5357"}, {"54", "\u897f\u85cf"}, {"61", "\u9655\u897f"}, {"62", "\u7518\u8083"}, {"63", "\u9752\u6d77"}, {"64", "\u5b81\u590f"}, {"65", "\u65b0\u7586"}, {"71", "\u53f0\u6e7e"}, {"81", "\u9999\u6e2f"}, {"82", "\u6fb3\u95e8"}, {"91", "\u56fd\u5916"}};
    private static String[] cityCode = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static Log logger = Logs.get();

    private IdcardUtils() {
    }

    public static boolean isValidatedAllIdcard(String idcard) {
        if (idcard.length() == 15) {
            idcard = IdcardUtils.convertIdcarBy15bit(idcard);
        }
        return IdcardUtils.isValidate18Idcard(Optional.ofNullable(idcard).orElse(""));
    }

    public static boolean isValidate18Idcard(String idcard) {
        if (idcard.length() != 18) {
            return false;
        }
        String idcard17 = idcard.substring(0, 17);
        String idcard18Code = idcard.substring(17, 18);
        char[] c = null;
        String checkCode = "";
        if (!IdcardUtils.isDigital(idcard17)) {
            return false;
        }
        c = idcard17.toCharArray();
        if (null != c) {
            int[] bit = IdcardUtils.converCharToInt(c);
            int sum17 = 0;
            sum17 = IdcardUtils.getPowerSum(bit);
            checkCode = IdcardUtils.getCheckCodeBySum(sum17);
            if (null == checkCode) {
                return false;
            }
            if (!idcard18Code.equalsIgnoreCase(checkCode)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidate15Idcard(String idcard) {
        if (idcard.length() == 15 && IdcardUtils.isDigital(idcard)) {
            Date birthdate;
            String provinceid = idcard.substring(0, 2);
            String birthday = idcard.substring(6, 12);
            int year = Integer.parseInt(idcard.substring(6, 8));
            int month = Integer.parseInt(idcard.substring(8, 10));
            int day = Integer.parseInt(idcard.substring(10, 12));
            try {
                birthdate = Times.parse((String)"yyMMdd", (String)birthday);
            }
            catch (ParseException e) {
                logger.debug((Object)e);
                return false;
            }
            if (!IdcardUtils.isProvinceAv(provinceid)) {
                return false;
            }
            if (!IdcardUtils.isBirthDayAv(birthdate)) {
                return false;
            }
            GregorianCalendar curDay = new GregorianCalendar();
            if (!IdcardUtils.isYearAndMonthAv(year, month, curDay) || !IdcardUtils.isDayAv(month, day, birthdate, curDay)) {
                return false;
            }
        }
        return false;
    }

    private static boolean isYearAndMonthAv(int year, int month, GregorianCalendar curDay) {
        int curYear = curDay.get(1);
        int year2bit = Integer.parseInt(String.valueOf(curYear).substring(2));
        if (year < 50 && year > year2bit) {
            return false;
        }
        return month >= 1 && month <= 12;
    }

    private static boolean isDayAv(int month, int day, Date birthdate, GregorianCalendar curDay) {
        curDay.setTime(birthdate);
        boolean mflag = month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12 ? day >= 1 && day <= 31 : (month == 4 || month == 6 || month == 9 || month == 11 ? day >= 1 && day <= 30 : (curDay.isLeapYear(curDay.get(1)) ? day >= 1 && day <= 29 : day >= 1 && day <= 28));
        return mflag;
    }

    private static boolean isBirthDayAv(Date birthday) {
        return birthday != null && birthday.before(Times.now());
    }

    private static boolean isProvinceAv(String provinceid) {
        for (String id : cityCode) {
            if (!id.equals(provinceid)) continue;
            return true;
        }
        return false;
    }

    public static String convertIdcarBy15bit(String idcard) {
        String idcard17 = null;
        if (idcard.length() != 15) {
            return null;
        }
        if (IdcardUtils.isDigital(idcard)) {
            String birthday = idcard.substring(6, 12);
            Date birthdate = null;
            try {
                birthdate = new SimpleDateFormat("yyMMdd").parse(birthday);
            }
            catch (ParseException e) {
                logger.debug((Object)e);
                return null;
            }
            Calendar cday = Calendar.getInstance();
            cday.setTime(birthdate);
            String year = String.valueOf(cday.get(1));
            idcard17 = idcard.substring(0, 6) + year + idcard.substring(8);
            char[] c = idcard17.toCharArray();
            String checkCode = "";
            if (null != c) {
                int[] bit = IdcardUtils.converCharToInt(c);
                int sum17 = 0;
                sum17 = IdcardUtils.getPowerSum(bit);
                checkCode = IdcardUtils.getCheckCodeBySum(sum17);
                if (null == checkCode) {
                    return null;
                }
                idcard17 = idcard17 + checkCode;
            }
        } else {
            return null;
        }
        return idcard17;
    }

    public static boolean isIdcard(String idcard) {
        return !Strings.isBlank((CharSequence)idcard) && Pattern.matches("(^\\d{15}$)|(\\d{17}(?:\\d|x|X)$)", idcard);
    }

    public static boolean is15Idcard(String idcard) {
        return !Strings.isBlank((CharSequence)idcard) && Pattern.matches("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$", idcard);
    }

    public static boolean is18Idcard(String idcard) {
        return Pattern.matches("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([\\d|x|X]{1})$", idcard);
    }

    public static boolean isDigital(String str) {
        return !Strings.isBlank((CharSequence)str) && str.matches("^[0-9]*$");
    }

    public static int getPowerSum(int[] bit) {
        int sum = 0;
        if (power.length != bit.length) {
            return sum;
        }
        for (int i = 0; i < bit.length; ++i) {
            for (int j = 0; j < power.length; ++j) {
                if (i != j) continue;
                sum += bit[i] * power[j];
            }
        }
        return sum;
    }

    public static String getCheckCodeBySum(int sum17) {
        String checkCode = null;
        switch (sum17 % 11) {
            case 10: {
                checkCode = "2";
                break;
            }
            case 9: {
                checkCode = "3";
                break;
            }
            case 8: {
                checkCode = "4";
                break;
            }
            case 7: {
                checkCode = "5";
                break;
            }
            case 6: {
                checkCode = "6";
                break;
            }
            case 5: {
                checkCode = "7";
                break;
            }
            case 4: {
                checkCode = "8";
                break;
            }
            case 3: {
                checkCode = "9";
                break;
            }
            case 2: {
                checkCode = "x";
                break;
            }
            case 1: {
                checkCode = "0";
                break;
            }
            case 0: {
                checkCode = "1";
                break;
            }
        }
        return checkCode;
    }

    public static int[] converCharToInt(char[] c) {
        int[] a = new int[c.length];
        int k = 0;
        for (char temp : c) {
            a[k++] = Integer.parseInt(String.valueOf(temp));
        }
        return a;
    }
}

