/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.captcha;

import com.chinare.axe.captcha.CaptchaGener;
import org.nutz.lang.random.R;

public class DefaultCaptchaGener
implements CaptchaGener {
    public static final String NUMBER_POOL = "0123456789";
    public static final String LETTER_POOL = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String DEFAULT_POOL = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private String pool;

    public static DefaultCaptchaGener instance(Type type) {
        switch (type) {
            case NUMBER: {
                return new DefaultCaptchaGener(NUMBER_POOL);
            }
            case LETTER: {
                return new DefaultCaptchaGener(LETTER_POOL);
            }
        }
        return new DefaultCaptchaGener();
    }

    public DefaultCaptchaGener() {
        this.pool = DEFAULT_POOL;
    }

    public DefaultCaptchaGener(String pool) {
        this.pool = pool;
    }

    @Override
    public String gen(int length) {
        if (length <= 0) {
            return "";
        }
        char[] pools = this.pool.toCharArray();
        StringBuilder bld = new StringBuilder();
        while (bld.length() < length) {
            bld.append(pools[R.random((int)0, (int)(pools.length - 1))]);
        }
        return bld.toString();
    }

    public static enum Type {
        DEFAULT,
        NUMBER,
        LETTER;

    }
}

