/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.Map;
import org.nutz.lang.Lang;
import org.nutz.lang.util.NutMap;

public class JwtUtil {
    private static final long EXPIRE_TIME = 3600000L;
    private static final long REMEMBER_EXPIRE_TIME = 31536000000L;

    private JwtUtil() {
    }

    public static boolean verify(String token, String username, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withSubject(username).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            throw Lang.makeThrow((String)"token \u4e0d\u5408\u6cd5", (Object[])new Object[0]);
        }
    }

    public static String getUsername(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getSubject();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }

    public static Map<String, Claim> getClaims(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaims();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }

    public static String sign(String username, String secret) {
        return JwtUtil.sign(username, secret, 3600000L);
    }

    public static String sign(String username, String secret, boolean rememberMe) {
        return JwtUtil.sign(username, secret, rememberMe ? 31536000000L : 3600000L);
    }

    public static String sign(String username, String secret, long expire) {
        Date date = new Date(System.currentTimeMillis() + expire);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withSubject(username).withExpiresAt(date).sign(algorithm);
    }

    public static String sign(String username, String secret, long expire, NutMap claims) {
        Date date = new Date(System.currentTimeMillis() + expire);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        JWTCreator.Builder builder = JWT.create().withSubject(username).withExpiresAt(date);
        claims.keySet().stream().forEach(key -> builder.withClaim(key, (String)claims.getAs(key, String.class)));
        return builder.sign(algorithm);
    }
}

