/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.auth;

import com.chinare.axe.auth.AuthService;
import com.chinare.axe.auth.JwtUtil;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.nutz.lang.Strings;

public abstract class AbstractAuthService
implements AuthService {
    static final String AUTHORIZATION_KEY = "Authorization";
    protected HttpServletRequest request;

    public AbstractAuthService(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public boolean authentication(List<String> withoutAuthenticationUrlRegulars) {
        return this.skip() || this.pass(this.request.getRequestURI(), withoutAuthenticationUrlRegulars) || this.user() != null;
    }

    protected boolean pass(String uri, List<String> withoutAuthenticationUrlRegulars) {
        for (String regular : withoutAuthenticationUrlRegulars) {
            if (!Pattern.matches(regular, uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String token() {
        Cookie[] cookies;
        String token = this.request.getHeader(AUTHORIZATION_KEY);
        if (token == null && (cookies = this.request.getCookies()) != null && cookies.length > 0) {
            for (Cookie ele : cookies) {
                if (!Strings.equalsIgnoreCase((String)ele.getName(), (String)AUTHORIZATION_KEY)) continue;
                token = ele.getValue();
                break;
            }
        }
        if (token == null) {
            token = this.request.getParameter(AUTHORIZATION_KEY);
        }
        return token;
    }

    @Override
    public String userName() {
        if (this.token() == null) {
            return null;
        }
        return JwtUtil.getUsername(this.token());
    }

    @Override
    public boolean skip() {
        return false;
    }
}

