/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.nutz.lang.Nums;

public class Numbers
extends Nums {
    public static String format(double number, int precision) {
        if (number == 0.0) {
            StringBuilder bld = new StringBuilder();
            bld.append("0.");
            for (int i = 0; i < precision; ++i) {
                bld.append("0");
            }
            return bld.toString();
        }
        number = Numbers.keepPrecision(number, precision);
        StringBuilder bld = new StringBuilder();
        bld.append("###,###.");
        for (int i = 0; i < precision; ++i) {
            bld.append("#");
        }
        DecimalFormat formatter = new DecimalFormat(bld.toString());
        String target = formatter.format(number);
        int ps = 0;
        if (target.split("\\.").length > 1) {
            ps = target.split("\\.")[1].length();
        } else {
            if (precision == 0) {
                return target.substring(0, target.length() - 1);
            }
            target = target + ".";
        }
        if (ps != precision) {
            for (int i = 0; i < precision - ps; ++i) {
                target = target + "0";
            }
        }
        return target;
    }

    public static String format(float number, int precision) {
        if (number == 0.0f) {
            StringBuilder temp = new StringBuilder("0.");
            for (int i = 0; i < precision; ++i) {
                temp.append("0");
            }
            return temp.toString();
        }
        number = Numbers.keepPrecision(number, precision);
        StringBuilder base = new StringBuilder("###,###.");
        for (int i = 0; i < precision; ++i) {
            base.append("#");
        }
        DecimalFormat formatter = new DecimalFormat(base.toString());
        String target = formatter.format(number);
        int ps = 0;
        if (target.split("\\.").length > 1) {
            ps = target.split("\\.")[1].length();
        } else {
            if (precision == 0) {
                return target.substring(0, target.length() - 1);
            }
            target = target + ".";
        }
        StringBuilder sb = new StringBuilder(target);
        if (ps != precision) {
            for (int i = 0; i < precision - ps; ++i) {
                sb.append(0);
            }
        }
        return sb.toString();
    }

    public static String format(Number number, int precision) {
        return Numbers.format(number.toString(), precision);
    }

    public static String format(String num, int precision) {
        return Numbers.format(Double.parseDouble(num), precision);
    }

    public static double keepPrecision(double number, int precision) {
        BigDecimal bg = BigDecimal.valueOf(number);
        return bg.setScale(precision, RoundingMode.HALF_UP).doubleValue();
    }

    public static float keepPrecision(float number, int precision) {
        BigDecimal bg = BigDecimal.valueOf(number);
        return bg.setScale(precision, RoundingMode.HALF_UP).floatValue();
    }

    public static String keepPrecision(Number number, int precision) {
        return Numbers.keepPrecision(String.valueOf(number), precision);
    }

    public static String keepPrecision(String number, int precision) {
        BigDecimal bg = new BigDecimal(number);
        return bg.setScale(precision, RoundingMode.HALF_UP).toPlainString();
    }
}

