/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.handler;

import com.chinare.axe.Result;
import java.util.List;
import java.util.regex.Pattern;
import org.nutz.lang.Lang;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class GlobalResponseHandler
implements ResponseBodyAdvice<Object> {
    List<String> ignorePaths;
    static final List<String> DEFAULT_IGNORED_PATH = Lang.list((Object[])new String[]{"/swagger-resources.*", "/v2/api-docs", "/actuator.*"});

    public GlobalResponseHandler(List<String> ignorePaths) {
        if (ignorePaths == null || ignorePaths.isEmpty()) {
            ignorePaths = DEFAULT_IGNORED_PATH;
        }
        ignorePaths.addAll(DEFAULT_IGNORED_PATH);
        this.ignorePaths = ignorePaths;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof Result || this.ignored(request.getURI().getRawPath())) {
            return body;
        }
        return Result.success(body);
    }

    private boolean ignored(String path) {
        return this.ignorePaths.stream().anyMatch(item -> Pattern.matches(item, path));
    }
}

