/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.handler;

import com.chinare.axe.Result;
import com.chinare.axe.auth.AuthException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.nutz.lang.Lang;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
public class GlobalExceptionHandler {
    Log log = Logs.get();

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result defaultErrorHandler(HttpServletResponse response, Exception e) {
        this.log.error((Object)e);
        return Result.exception(e);
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result handle(ValidationException e) {
        this.log.error((Object)e);
        if (e instanceof ConstraintViolationException) {
            ArrayList errors = new ArrayList();
            ArrayList infos = Lang.list((Object[])new String[0]);
            ((ConstraintViolationException)e).getConstraintViolations().stream().forEach(error -> {
                infos.add(error.getMessage());
                errors.add(NutMap.NEW().addv("msg", (Object)error.getMessage()).addv("obj", (Object)error.getConstraintDescriptor()).addv("arguments", (Object)error.getExecutableParameters()));
            });
            return Result.exception(infos).addExtData("details", errors);
        }
        return Result.fail("\u53c2\u6570\u4e0d\u6b63\u786e");
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Result validate(HttpServletResponse response, MethodArgumentNotValidException e) {
        this.log.error((Object)e);
        ArrayList errors = new ArrayList();
        ArrayList infos = Lang.list((Object[])new String[0]);
        e.getBindingResult().getAllErrors().stream().forEach(error -> {
            infos.add(error.getDefaultMessage());
            errors.add(NutMap.NEW().addv("msg", (Object)error.getDefaultMessage()).addv("obj", (Object)error.getObjectName()).addv("arguments", (Object)error.getArguments()).addv("code", (Object)error.getCode()).addv("codes", (Object)error.getCodes()));
        });
        return Result.exception(infos).addExtData("details", errors);
    }

    @ExceptionHandler(value={AuthException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public Result auth(HttpServletResponse response, Exception e) {
        this.log.error((Object)e);
        return Result.exception("\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u64cd\u4f5c!");
    }
}

