/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.auth;

import com.chinare.axe.auth.Auth;
import com.chinare.axe.auth.AuthException;
import com.chinare.axe.auth.AuthService;
import java.lang.reflect.Method;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
public class TokenAuthInterceptor {
    AuthService authService;
    List<String> withoutAuthenticationUrlRegulars;
    Log logger = Logs.get();

    public TokenAuthInterceptor(AuthService authService, List<String> withoutAuthenticationUrlRegulars) {
        this.authService = authService;
        this.withoutAuthenticationUrlRegulars = withoutAuthenticationUrlRegulars;
    }

    public Auth getAuth(JoinPoint joinPoint) {
        MethodSignature joinPointObject = (MethodSignature)joinPoint.getSignature();
        Method method = joinPointObject.getMethod();
        boolean flag = method.isAnnotationPresent(Auth.class);
        if (flag) {
            return method.getAnnotation(Auth.class);
        }
        Auth classAnnotation = (Auth)AnnotationUtils.findAnnotation(joinPointObject.getMethod().getDeclaringClass(), Auth.class);
        if (classAnnotation != null) {
            return classAnnotation;
        }
        return null;
    }

    @Around(value="@within(com.kerbores.mdp.axe.auth.Auth)|| @annotation(com.kerbores.mdp.axe.auth.Auth)")
    public Object filter(ProceedingJoinPoint point) throws Throwable {
        if (!this.authService.authentication(this.withoutAuthenticationUrlRegulars)) {
            throw new AuthException();
        }
        Auth auth = this.getAuth((JoinPoint)point);
        if (auth == null || auth.value().length == 0) {
            return point.proceed();
        }
        if (this.checkAuth(auth)) {
            return point.proceed();
        }
        throw new AuthException();
    }

    private boolean checkAuth(Auth auth) {
        if (this.authService.user() == null) {
            return false;
        }
        if (auth.type() == Auth.AuthType.ROLE) {
            return this.checkRole(auth.value(), auth.logical());
        }
        return this.checkPermission(auth.value(), auth.logical());
    }

    private boolean checkPermission(String[] value, Auth.Logical logical) {
        if (logical == Auth.Logical.AND) {
            for (String p : value) {
                if (this.hasPermission(p)) continue;
                this.logger.debugf("user does not has peermission %s", new Object[]{p});
                return false;
            }
            return true;
        }
        for (String p : value) {
            if (!this.hasPermission(p)) continue;
            return true;
        }
        this.logger.debugf("user does not has any permission of %s", new Object[]{Json.toJson((Object)value, (JsonFormat)JsonFormat.compact())});
        return false;
    }

    private boolean hasPermission(String p) {
        List<String> list = this.authService.permissions();
        for (String permission : list) {
            if (!Strings.equals((String)permission, (String)p)) continue;
            return true;
        }
        return false;
    }

    private boolean checkRole(String[] value, Auth.Logical logical) {
        if (logical == Auth.Logical.AND) {
            for (String r : value) {
                if (this.hasRole(r)) continue;
                this.logger.debugf("user does not has role %s", new Object[]{r});
                return false;
            }
            return true;
        }
        for (String r : value) {
            if (!this.hasRole(r)) continue;
            return true;
        }
        this.logger.debugf("user does not has any role of %s", new Object[]{Json.toJson((Object)value, (JsonFormat)JsonFormat.compact())});
        return false;
    }

    private boolean hasRole(String r) {
        for (String role : this.authService.roles()) {
            if (!Strings.equals((String)role, (String)r)) continue;
            return true;
        }
        return false;
    }
}

