/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.auth;

import com.chinare.axe.auth.JwtUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.nutz.lang.util.NutMap;

public class AuthUser {
    @ApiModelProperty(required=true, value="\u7528\u6237\u540d")
    String userName;
    @ApiModelProperty(required=true, value="\u5bc6\u7801")
    String password;
    @ApiModelProperty(required=true, value="jwt Token")
    String token;
    @ApiModelProperty(required=true, value="\u89d2\u8272\u5217\u8868")
    List<String> roles;
    @ApiModelProperty(required=true, value="\u6743\u9650\u5217\u8868")
    List<String> permissions;
    @ApiModelProperty(required=true, value="\u6269\u5c55\u4fe1\u606f")
    NutMap extInfo;

    public AuthUser addExt(String key, Object value) {
        this.getExtInfo().setv(key, value);
        return this;
    }

    public AuthUser token() {
        this.setToken(JwtUtil.sign(this.userName, this.password, true));
        return this;
    }

    private static NutMap $default$extInfo() {
        return NutMap.NEW();
    }

    public static AuthUserBuilder builder() {
        return new AuthUserBuilder();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public NutMap getExtInfo() {
        return this.extInfo;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void setExtInfo(NutMap extInfo) {
        this.extInfo = extInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthUser)) {
            return false;
        }
        AuthUser other = (AuthUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        List<String> this$roles = this.getRoles();
        List<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        List<String> this$permissions = this.getPermissions();
        List<String> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        NutMap this$extInfo = this.getExtInfo();
        NutMap other$extInfo = other.getExtInfo();
        return !(this$extInfo == null ? other$extInfo != null : !this$extInfo.equals(other$extInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        List<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        List<String> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        NutMap $extInfo = this.getExtInfo();
        result = result * 59 + ($extInfo == null ? 43 : $extInfo.hashCode());
        return result;
    }

    public String toString() {
        return "AuthUser(userName=" + this.getUserName() + ", password=" + this.getPassword() + ", token=" + this.getToken() + ", roles=" + this.getRoles() + ", permissions=" + this.getPermissions() + ", extInfo=" + this.getExtInfo() + ")";
    }

    public AuthUser() {
        this.extInfo = AuthUser.$default$extInfo();
    }

    public AuthUser(String userName, String password, String token, List<String> roles, List<String> permissions, NutMap extInfo) {
        this.userName = userName;
        this.password = password;
        this.token = token;
        this.roles = roles;
        this.permissions = permissions;
        this.extInfo = extInfo;
    }

    public static class AuthUserBuilder {
        private String userName;
        private String password;
        private String token;
        private List<String> roles;
        private List<String> permissions;
        private boolean extInfo$set;
        private NutMap extInfo$value;

        AuthUserBuilder() {
        }

        public AuthUserBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public AuthUserBuilder password(String password) {
            this.password = password;
            return this;
        }

        public AuthUserBuilder token(String token) {
            this.token = token;
            return this;
        }

        public AuthUserBuilder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        public AuthUserBuilder permissions(List<String> permissions) {
            this.permissions = permissions;
            return this;
        }

        public AuthUserBuilder extInfo(NutMap extInfo) {
            this.extInfo$value = extInfo;
            this.extInfo$set = true;
            return this;
        }

        public AuthUser build() {
            NutMap extInfo$value = this.extInfo$value;
            if (!this.extInfo$set) {
                extInfo$value = AuthUser.$default$extInfo();
            }
            return new AuthUser(this.userName, this.password, this.token, this.roles, this.permissions, extInfo$value);
        }

        public String toString() {
            return "AuthUser.AuthUserBuilder(userName=" + this.userName + ", password=" + this.password + ", token=" + this.token + ", roles=" + this.roles + ", permissions=" + this.permissions + ", extInfo$value=" + this.extInfo$value + ")";
        }
    }
}

