/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.apm;

import com.chinare.axe.apm.Apm;
import com.chinare.axe.apm.ApmAppender;
import com.chinare.axe.apm.URLProvider;
import com.chinare.axe.apm.UserCollector;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.nutz.lang.Stopwatch;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.annotation.Async;

@Aspect
public class ApmInterceptor {
    ApmAppender appender;
    UserCollector collector;
    URLProvider urlProvider;

    public ApmInterceptor(ApmAppender appender, UserCollector collector, URLProvider urlProvider) {
        this.appender = appender;
        this.collector = collector;
        this.urlProvider = urlProvider;
    }

    public Apm getApm(JoinPoint joinPoint) {
        MethodSignature joinPointObject = (MethodSignature)joinPoint.getSignature();
        Method method = joinPointObject.getMethod();
        boolean flag = method.isAnnotationPresent(Apm.class);
        if (flag) {
            return method.getAnnotation(Apm.class);
        }
        Apm classAnnotation = (Apm)AnnotationUtils.findAnnotation(joinPointObject.getMethod().getDeclaringClass(), Apm.class);
        if (classAnnotation != null) {
            return classAnnotation;
        }
        return null;
    }

    @Around(value="@within(com.chinare.axe.apm.Apm)|| @annotation(com.chinare.axe.apm.Apm)")
    public Object filter(ProceedingJoinPoint point) throws Throwable {
        Apm log = this.getApm((JoinPoint)point);
        Object[] args = point.getArgs();
        Object obj = null;
        long duration = 0L;
        boolean exception = false;
        try {
            Stopwatch stopwatch = Stopwatch.beginNano();
            obj = point.proceed();
            stopwatch.stop();
            duration = stopwatch.getDuration();
        }
        catch (Throwable e) {
            exception = true;
            throw e;
        }
        finally {
            this.log(this.appender.collect(this.urlProvider.provide(), this.collector.collector(), log, args, obj, duration, exception));
        }
        return obj;
    }

    @Async
    public void log(ApmAppender.ApmLog log) {
        this.appender.append(log);
    }
}

