/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe;

import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.util.NutMap;

public class Result<T> {
    @ApiModelProperty(value="\u54cd\u5e94\u6269\u5c55\u6570\u636e", required=false)
    private NutMap ext;
    @ApiModelProperty(value="\u54cd\u5e94\u72b6\u6001", required=true)
    private OperationState state;
    @ApiModelProperty(value="\u9519\u8bef\u4fe1\u606f\u5217\u8868")
    private String[] errors;
    @ApiModelProperty(value="\u54cd\u5e94\u6570\u636e", required=true)
    private T data;

    public static Result success() {
        return Result.builder().build();
    }

    public static <T> Result<T> success(T t) {
        return Result.builder().data(t).build();
    }

    public static Result fail(String ... errors) {
        return Result.builder().state(OperationState.FAIL).errors(errors).build();
    }

    public static Result exception(String ... errors) {
        return Result.builder().state(OperationState.EXCEPTION).errors(errors).build();
    }

    public static Result exception(List<String> errors) {
        return Result.builder().state(OperationState.EXCEPTION).errors(errors.toArray(new String[errors.size()])).build();
    }

    public static Result exception(Throwable ... exceptions) {
        return Result.exception(Arrays.stream(exceptions).map(Throwable::getMessage).collect(Collectors.toList()));
    }

    public Result addExtData(String key, Object value) {
        this.getExt().setv(key, value);
        return this;
    }

    public boolean isSuccess() {
        return this.getState() == OperationState.SUCCESS;
    }

    public String toString() {
        return Json.toJson((Object)this, (JsonFormat)JsonFormat.forLook());
    }

    private static <T> NutMap $default$ext() {
        return new NutMap();
    }

    private static <T> OperationState $default$state() {
        return OperationState.SUCCESS;
    }

    public static <T> ResultBuilder<T> builder() {
        return new ResultBuilder();
    }

    public NutMap getExt() {
        return this.ext;
    }

    public OperationState getState() {
        return this.state;
    }

    public String[] getErrors() {
        return this.errors;
    }

    public T getData() {
        return this.data;
    }

    public void setExt(NutMap ext) {
        this.ext = ext;
    }

    public void setState(OperationState state) {
        this.state = state;
    }

    public void setErrors(String[] errors) {
        this.errors = errors;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NutMap this$ext = this.getExt();
        NutMap other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !this$ext.equals(other$ext)) {
            return false;
        }
        OperationState this$state = this.getState();
        OperationState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getErrors(), other.getErrors())) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NutMap $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : $ext.hashCode());
        OperationState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getErrors());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public Result() {
        this.ext = Result.$default$ext();
        this.state = Result.$default$state();
    }

    public Result(NutMap ext, OperationState state, String[] errors, T data) {
        this.ext = ext;
        this.state = state;
        this.errors = errors;
        this.data = data;
    }

    public static class ResultBuilder<T> {
        private boolean ext$set;
        private NutMap ext$value;
        private boolean state$set;
        private OperationState state$value;
        private String[] errors;
        private T data;

        ResultBuilder() {
        }

        public ResultBuilder<T> ext(NutMap ext) {
            this.ext$value = ext;
            this.ext$set = true;
            return this;
        }

        public ResultBuilder<T> state(OperationState state) {
            this.state$value = state;
            this.state$set = true;
            return this;
        }

        public ResultBuilder<T> errors(String[] errors) {
            this.errors = errors;
            return this;
        }

        public ResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public Result<T> build() {
            NutMap ext$value = this.ext$value;
            if (!this.ext$set) {
                ext$value = Result.$default$ext();
            }
            OperationState state$value = this.state$value;
            if (!this.state$set) {
                state$value = Result.$default$state();
            }
            return new Result<T>(ext$value, state$value, this.errors, this.data);
        }

        public String toString() {
            return "Result.ResultBuilder(ext$value=" + this.ext$value + ", state$value=" + (Object)((Object)this.state$value) + ", errors=" + Arrays.deepToString(this.errors) + ", data=" + this.data + ")";
        }
    }

    public static enum OperationState {
        SUCCESS,
        FAIL,
        EXCEPTION;

    }
}

