/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.log.impl;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nutz.log.Log;
import org.nutz.log.LogAdapter;
import org.nutz.log.Logs;
import org.nutz.log.impl.AbstractLog;
import org.nutz.plugin.Plugin;

public class CustomLogAdapter
implements LogAdapter,
Plugin {
    public Log getLogger(String className) {
        return new Log4J2Logger(className);
    }

    public boolean canWork() {
        try {
            Logger.class.getName();
            return true;
        }
        catch (Exception e) {
            Logs.get().debug((Object)e);
            return false;
        }
    }

    static class Log4J2Logger
    extends AbstractLog {
        private Logger logger;

        public Log4J2Logger(String className) {
            this.logger = LogManager.getLogger((String)className);
            this.isFatalEnabled = this.logger.isFatalEnabled();
            this.isErrorEnabled = this.logger.isErrorEnabled();
            this.isWarnEnabled = this.logger.isWarnEnabled();
            this.isInfoEnabled = this.logger.isInfoEnabled();
            this.isDebugEnabled = this.logger.isDebugEnabled();
            this.isTraceEnabled = this.logger.isTraceEnabled();
        }

        protected void log(int level, Object message, Throwable tx) {
            switch (level) {
                case 50: {
                    this.logger.log(Level.FATAL, message, tx);
                    break;
                }
                case 40: {
                    this.logger.log(Level.ERROR, message, tx);
                    break;
                }
                case 30: {
                    this.logger.log(Level.WARN, message, tx);
                    break;
                }
                case 20: {
                    this.logger.log(Level.INFO, message, tx);
                    break;
                }
                case 10: {
                    this.logger.log(Level.DEBUG, message, tx);
                    break;
                }
                case 0: {
                    this.logger.log(Level.TRACE, message, tx);
                    break;
                }
            }
        }

        public void fatal(Object message, Throwable t) {
            this.log(50, message, t);
        }

        public void error(Object message, Throwable t) {
            this.log(40, message, t);
        }

        public void warn(Object message, Throwable t) {
            this.log(30, message, t);
        }

        public void info(Object message, Throwable t) {
            this.log(20, message, t);
        }

        public void debug(Object message, Throwable t) {
            this.log(10, message, t);
        }

        public void trace(Object message, Throwable t) {
            this.log(0, message, t);
        }
    }
}

