/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.nutz.filepool.NutFilePool;
import org.nutz.http.Header;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.img.Images;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.repo.Base64;

public class ImageUtils
extends Images {
    static NutFilePool pool = new NutFilePool(System.getProperty("java.io.tmpdir"), 3000L);
    private static final Log log = Logs.get();

    private ImageUtils() {
    }

    public static BufferedImage zoomAndClip(File src, double scale, int xStart, int yStart, int xEnd, int yEnd) throws IOException {
        BufferedImage bfi = ImageUtils.read((Object)src);
        bfi = ImageUtils.zoomScale((BufferedImage)bfi, (int)((int)((double)bfi.getWidth() * scale)), (int)((int)((double)bfi.getHeight() * scale)));
        File f = pool.createFile("." + Files.getSuffixName((File)src));
        ImageUtils.write((RenderedImage)bfi, (File)f);
        ImageUtils.clipScale((String)f.getPath(), (String)f.getPath(), (int[])new int[]{xStart, yStart}, (int[])new int[]{xEnd, yEnd});
        return ImageUtils.read((Object)f);
    }

    public static BufferedImage zoomAndClip(File src, double scale, Point start, Point end) throws IOException {
        return ImageUtils.zoomAndClip(src, scale, start.getXaxis(), start.getYaxis(), end.getXaxis(), end.getYaxis());
    }

    public static File toFile(BufferedImage bfi) {
        File f = pool.createFile(".jpg");
        ImageUtils.writeJpeg((RenderedImage)bfi, (Object)f, (float)1.0f);
        return f;
    }

    public static BufferedImage zoomAndClip(File src, double scale, Point start, int w, int h) throws IOException {
        return ImageUtils.zoomAndClip(src, scale, start.getXaxis(), start.getYaxis(), start.getXaxis() + w, start.getYaxis() + h);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File generateImage(String imgStr, File outFile) {
        if (imgStr == null) {
            return null;
        }
        try (FileOutputStream out = new FileOutputStream(outFile);){
            byte[] b = Base64.decode((String)imgStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            ((OutputStream)out).write(b);
            out.flush();
            File file = outFile;
            return file;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    public static File generateImage(String imgStr, File outDir, String suffix) {
        File file = new File(outDir.getPath() + File.separator + System.nanoTime() + "." + suffix);
        return ImageUtils.generateImage(imgStr, file);
    }

    public static File generatePngImage(String imgStr) {
        return ImageUtils.generateImage(imgStr, new File(System.nanoTime() + ".png"));
    }

    public static String getImageStr(File imgFile) {
        return Base64.encodeToString((byte[])Files.readBytes((File)imgFile), (boolean)false);
    }

    public static NutMap baiduOcr(String path, String key) {
        NutMap params = NutMap.NEW();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("apikey", key);
        params.put((Object)"fromdevice", (Object)"pc");
        params.put((Object)"clientip", (Object)"10.0.1.1");
        params.put((Object)"detecttype", (Object)"LocateRecognize");
        params.put((Object)"languagetype", (Object)"CHN_ENG");
        params.put((Object)"imagetype", (Object)"1");
        params.put((Object)"image", (Object)ImageUtils.getImageStr(new File(path)));
        Request request = Request.create((String)"http://apis.baidu.com/apistore/idlocr/ocr", (Request.METHOD)Request.METHOD.POST, (Map)params, (Header)Header.create(header));
        Sender sender = Sender.create((Request)request);
        Response response = sender.send();
        String info = response.getContent();
        return Lang.map((String)info);
    }

    public static class Point {
        private int x;
        private int y;

        public int getXaxis() {
            return this.x;
        }

        public void setXaxis(int x) {
            this.x = x;
        }

        public int getYaxis() {
            return this.y;
        }

        public void setYaxis(int y) {
            this.y = y;
        }

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Point(Number x, Number y) {
            this.x = x.intValue();
            this.y = y.intValue();
        }

        public Point() {
        }
    }
}

