/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.utils;

import com.chinare.axe.utils.DateUtils;
import java.util.Date;
import org.nutz.lang.Lang;
import org.nutz.lang.Times;
import org.nutz.log.Logs;

public class IdWorker {
    private final long workerId;
    private static final long TWE_POCH = 1288834974657L;
    private long sequence = 0L;
    private static final long WORKER_ID_BITS = 4L;
    public static final long MAX_WORKER_ID = 15L;
    private static final long SEQUENCE_BITS = 10L;
    private static final long WORKER_ID_SHIFT = 10L;
    private static final long TIMESTAMP_LEFT_SHIFT = 14L;
    public static final long SEQUENCE_MASK = 1023L;
    private long lastTimestamp = -1L;

    public IdWorker(long workerId) {
        if (workerId > 15L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 15L));
        }
        this.workerId = workerId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                Logs.get().debug((Object)"###########1023");
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        if (timestamp < this.lastTimestamp) {
            throw Lang.makeThrow((String)"Clock moved backwards.  Refusing to generate id for %d milliseconds", (Object[])new Object[]{this.lastTimestamp - timestamp});
        }
        this.lastTimestamp = timestamp;
        long nextId = timestamp - 1288834974657L << 14 | this.workerId << 10 | this.sequence;
        Logs.get().debug((Object)("timestamp:" + timestamp + ",timestampLeftShift:" + 14L + ",nextId:" + nextId + ",workerId:" + this.workerId + ",sequence:" + this.sequence));
        return nextId;
    }

    public synchronized String nextIdForEc() {
        long timestamp = this.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                Logs.get().debug((Object)"###########1023");
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        if (timestamp < this.lastTimestamp) {
            throw Lang.makeThrow((String)"Clock moved backwards.  Refusing to generate id for %d milliseconds", (Object[])new Object[]{this.lastTimestamp - timestamp});
        }
        this.lastTimestamp = timestamp;
        long nextId = timestamp - 1288834974657L << 14 | this.workerId << 10 | this.sequence;
        Logs.get().debug((Object)("timestamp:" + timestamp + ",timestampLeftShift:" + 14L + ",nextId:" + nextId + ",workerId:" + this.workerId + ",sequence:" + this.sequence));
        return DateUtils.format((String)"yyyyMM", (Date)Times.now()) + nextId;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

