/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import org.nutz.lang.Files;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class FileUtils {
    private static final Log log = Logs.get();

    private FileUtils() {
    }

    public static boolean cleanSvn(File dir) {
        try {
            Files.cleanAllFolderInSubFolderes((File)dir, (String)".svn");
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public static long countJavaCodeLines(File file) {
        return FileUtils.countLines(file, ".java");
    }

    public static double getDirSize(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                double size = 0.0;
                for (File f : children) {
                    size += FileUtils.getDirSize(f);
                }
                return size;
            }
            return file.length();
        }
        return 0.0;
    }

    public static String formetFileSize(double length) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = length < 1024.0 ? df.format(length) + "B" : (length < 1048576.0 ? df.format(length / 1024.0) + "K" : (length < 1.073741824E9 ? df.format(length / 1048576.0) + "M" : df.format(length / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static long countLine(File file) {
        long target = 0L;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                log.debug((Object)line);
                ++target;
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        return target;
    }

    public static long countLines(File file, String suf) {
        long target = 0L;
        if (file.isFile() && file.getName().endsWith(suf)) {
            return FileUtils.countLine(file);
        }
        if (file.isFile()) {
            return 0L;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                target += FileUtils.countLines(f, suf);
            }
        }
        return target;
    }

    public static File fastFindFile(File dir, String name) {
        return FileUtils.fastFindFile(dir, name, 1);
    }

    public static File fastFindFile(File dir, String name, int method) {
        File target = null;
        File[] dirs = Files.dirs((File)dir);
        File[] files = Files.files((File)dir, (String)name);
        if (files != null) {
            for (File file : files) {
                if (!FileUtils.matchs(file.getName(), name, method)) continue;
                return file;
            }
        }
        if (dirs != null) {
            for (File file : dirs) {
                target = FileUtils.fastFindFile(file, name, method);
                if (target == null) continue;
                return target;
            }
        }
        return target;
    }

    private static boolean matchs(String fileName, String name, int method) {
        switch (method) {
            case 1: {
                return Strings.equals((String)fileName, (String)name);
            }
            case 2: {
                return fileName.endsWith(name);
            }
            case 3: {
                return Strings.equals((String)fileName.toUpperCase(), (String)name.toUpperCase());
            }
        }
        return fileName.toUpperCase().endsWith(name.toUpperCase());
    }

    public static File fastFindFile(String dir, String name) {
        return FileUtils.fastFindFile(new File(dir), name, 1);
    }

    public static File fastFindFileLikeName(File dir, String name) {
        return FileUtils.fastFindFile(dir, name, 2);
    }

    public static File findFile(File dir, String name) {
        File target = null;
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile() && Strings.equals((String)file.getName(), (String)name)) {
                    return file;
                }
                if (!file.isDirectory() || (target = FileUtils.findFile(file, name)) == null) continue;
                return target;
            }
        }
        return target;
    }
}

