/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.nutz.lang.Times;

public class DateUtils
extends Times {
    public static final String DATE_FORMAT_MONTH = "yyyy-MM";
    public static final String DATE_FORMAT_DAY = "yyyy-MM-dd";

    public static Date addDays(Date base, int days) {
        return DateUtils.D((long)(base.getTime() + (long)(days * 24 * 60 * 60) * 1000L));
    }

    public static Date addDays(int days) {
        return DateUtils.addDays(DateUtils.now(), days);
    }

    public static double daysBetween(Date start, Date end) {
        return BigDecimal.valueOf((double)(end.getTime() - start.getTime()) / 1000.0 / 24.0 / 60.0 / 60.0).setScale(0, RoundingMode.HALF_UP).doubleValue();
    }

    public static Date getDayStart(Date d) {
        return DateUtils.D((String)DateUtils.format((String)"yyyy-MM-dd 00:00:00", (Date)d));
    }

    public static Date getDayEnd(Date d) {
        return DateUtils.D((String)DateUtils.format((String)"yyyy-MM-dd 23:59:59", (Date)d));
    }

    public static Date getDayStart() {
        return DateUtils.D((String)DateUtils.format((String)"yyyy-MM-dd 00:00:00", (Date)DateUtils.now()));
    }

    public static Date getDayEnd() {
        return DateUtils.D((String)DateUtils.format((String)"yyyy-MM-dd 23:59:59", (Date)DateUtils.now()));
    }

    public static Date getWeekEnd(boolean startFromSunday) {
        Date date = DateUtils.addDays(DateUtils.getWeekStart(startFromSunday), 6);
        return DateUtils.getDayEnd(date);
    }

    public static Date getWeekEnd(boolean startFromSunday, Date date) {
        Date newDate = DateUtils.addDays(DateUtils.getWeekStart(startFromSunday, date), 6);
        return DateUtils.getDayEnd(newDate);
    }

    public static Date getWeekStart(boolean startFromSunday) {
        return DateUtils.addDays(DateUtils.getDayStart(), -1 * (Times.C((Date)DateUtils.now()).get(7) - 1 - (startFromSunday ? 0 : 1)));
    }

    public static Date getWeekStart(boolean startFromSunday, Date date) {
        return DateUtils.addDays(DateUtils.getDayStart(date), -1 * (Times.C((Date)DateUtils.now()).get(7) - 1 - (startFromSunday ? 0 : 1)));
    }

    public static Date addSeconds(Date base, long seconds) {
        return DateUtils.D((long)(base.getTime() + seconds * 1000L));
    }

    public static Date addSeconds(long seconds) {
        return DateUtils.addSeconds(DateUtils.now(), seconds);
    }

    public static Date getYearStart(Date d) {
        String year = DateUtils.format((String)"yyyy", (Date)d);
        year = year + "-01-01";
        return DateUtils.D((String)year);
    }

    public static Date getYearStart() {
        return DateUtils.getYearStart(DateUtils.now());
    }

    public static Date getYearEnd(Date d) {
        String year = DateUtils.format((String)"yyyy", (Date)d);
        year = year + "-12-31";
        return DateUtils.getDayEnd(DateUtils.D((String)year));
    }

    public static Date getYearEnd() {
        return DateUtils.getYearEnd(DateUtils.now());
    }

    public static Date getMonthStart(Date d) {
        String month = DateUtils.format((String)DATE_FORMAT_MONTH, (Date)d) + "-01";
        return DateUtils.D((String)month);
    }

    public static Date getMonthStart() {
        return DateUtils.getMonthStart(DateUtils.now());
    }

    public static Date getMonthEnd(Date d) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(d);
        ca.set(5, ca.getActualMaximum(5));
        return DateUtils.getDayEnd(ca.getTime());
    }

    public static Date getMonthEnd() {
        return DateUtils.getMonthEnd(DateUtils.now());
    }

    public static String getSequence() {
        String sequence = DateUtils.format((String)"yyyyMMDD", (Date)DateUtils.now());
        sequence = sequence + DateUtils.ms() % 10000;
        return sequence;
    }

    public static String getYearStartMonth() {
        return DateUtils.format((String)DATE_FORMAT_MONTH, (Date)DateUtils.getYearStart());
    }

    public static String getYearStartMonth(Date date) {
        return DateUtils.format((String)DATE_FORMAT_MONTH, (Date)DateUtils.getYearStart(date));
    }

    public static String getYearEndMonth() {
        return DateUtils.format((String)DATE_FORMAT_MONTH, (Date)DateUtils.getYearEnd());
    }

    public static String getYearEndMonth(Date date) {
        return DateUtils.format((String)DATE_FORMAT_MONTH, (Date)DateUtils.getYearEnd(date));
    }

    public static String getMonthStartDate() {
        return DateUtils.format((String)DATE_FORMAT_DAY, (Date)DateUtils.getMonthStart());
    }

    public static String getMonthStartDate(Date date) {
        return DateUtils.format((String)DATE_FORMAT_DAY, (Date)DateUtils.getMonthStart(date));
    }

    public static String getMonthEndDate() {
        return DateUtils.format((String)DATE_FORMAT_DAY, (Date)DateUtils.getMonthEnd());
    }

    public static String getMonthEndDate(Date date) {
        return DateUtils.format((String)DATE_FORMAT_DAY, (Date)DateUtils.getMonthEnd(date));
    }

    public static int getDayOfMonth() {
        return Calendar.getInstance(Locale.CHINA).getActualMaximum(5);
    }
}

