/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.swagger;

import com.chinare.axe.swagger.Swagger2Configuration;
import com.chinare.axe.swagger.SwaggerConfigurationProerties;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.nutz.lang.Lang;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.ApiKeyVehicle;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger.web.UiConfigurationBuilder;

@Configuration
@Import(value={Swagger2Configuration.class})
public class SwaggerAutoConfiguration
implements BeanFactoryAware {
    private BeanFactory beanFactory;

    @Bean
    @ConditionalOnMissingBean
    public SwaggerConfigurationProerties swaggerConfigurationProerties() {
        return new SwaggerConfigurationProerties();
    }

    @Bean
    public UiConfiguration uiConfiguration(SwaggerConfigurationProerties swaggerConfigurationProerties) {
        return UiConfigurationBuilder.builder().deepLinking(swaggerConfigurationProerties.getUiConfig().getDeepLinking()).defaultModelExpandDepth(swaggerConfigurationProerties.getUiConfig().getDefaultModelExpandDepth()).defaultModelRendering(swaggerConfigurationProerties.getUiConfig().getDefaultModelRendering()).defaultModelsExpandDepth(swaggerConfigurationProerties.getUiConfig().getDefaultModelsExpandDepth()).displayOperationId(swaggerConfigurationProerties.getUiConfig().getDisplayOperationId()).displayRequestDuration(swaggerConfigurationProerties.getUiConfig().getDisplayRequestDuration()).docExpansion(swaggerConfigurationProerties.getUiConfig().getDocExpansion()).maxDisplayedTags(swaggerConfigurationProerties.getUiConfig().getMaxDisplayedTags()).operationsSorter(swaggerConfigurationProerties.getUiConfig().getOperationsSorter()).showExtensions(swaggerConfigurationProerties.getUiConfig().getShowExtensions()).tagsSorter(swaggerConfigurationProerties.getUiConfig().getTagsSorter()).validatorUrl(swaggerConfigurationProerties.getUiConfig().getValidatorUrl()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={UiConfiguration.class})
    @ConditionalOnProperty(name={"swagger.enabled"}, matchIfMissing=true)
    public List<Docket> createRestApi(SwaggerConfigurationProerties swaggerConfigurationProerties) {
        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)this.beanFactory;
        ArrayList docketList = Lists.newArrayList();
        if (swaggerConfigurationProerties.getDocket().size() == 0) {
            return this.createRestApiWithoutDocket(swaggerConfigurationProerties, configurableBeanFactory, docketList);
        }
        return this.createRestApiWithDocketInfo(swaggerConfigurationProerties, configurableBeanFactory, docketList);
    }

    private List<Docket> createRestApiWithDocketInfo(SwaggerConfigurationProerties swaggerConfigurationProerties, ConfigurableBeanFactory configurableBeanFactory, List<Docket> docketList) {
        for (String groupName : swaggerConfigurationProerties.getDocket().keySet()) {
            SwaggerConfigurationProerties.DocketInfo docketInfo = swaggerConfigurationProerties.getDocket().get(groupName);
            ApiInfo apiInfo = this.createApiInfo(swaggerConfigurationProerties, docketInfo);
            if (docketInfo.getBasePath().isEmpty()) {
                docketInfo.getBasePath().add("/**");
            }
            ArrayList<Predicate> basePath = new ArrayList<Predicate>();
            for (String string : docketInfo.getBasePath()) {
                basePath.add(PathSelectors.ant((String)string));
            }
            ArrayList<Predicate> excludePath = new ArrayList<Predicate>();
            for (String path3 : docketInfo.getExcludePath()) {
                excludePath.add(PathSelectors.ant((String)path3));
            }
            Docket docket = new Docket(DocumentationType.SWAGGER_2).host(swaggerConfigurationProerties.getHost()).apiInfo(apiInfo).securitySchemes(Collections.singletonList(this.apiKey())).securityContexts(Collections.singletonList(this.securityContext())).globalOperationParameters(this.assemblyGlobalOperationParameters(swaggerConfigurationProerties.getGlobalOperationParameters(), docketInfo.getGlobalOperationParameters()));
            if (!swaggerConfigurationProerties.getApplyDefaultResponseMessages().booleanValue()) {
                this.buildGlobalResponseMessage(swaggerConfigurationProerties, docket);
            }
            Docket docket2 = docket.groupName(groupName).select().apis(RequestHandlerSelectors.basePackage((String)docketInfo.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or(excludePath)), (Predicate)Predicates.or(basePath))).build();
            Class[] array = new Class[docketInfo.getIgnoredParameterTypes().size()];
            Class[] ignoredParameterTypes = docketInfo.getIgnoredParameterTypes().toArray(array);
            docket2.ignoredParameterTypes(ignoredParameterTypes);
            configurableBeanFactory.registerSingleton(groupName, (Object)docket2);
            docketList.add(docket2);
        }
        return docketList;
    }

    private ApiInfo createApiInfo(SwaggerConfigurationProerties swaggerConfigurationProerties, SwaggerConfigurationProerties.DocketInfo docketInfo) {
        return new ApiInfoBuilder().title(docketInfo.getTitle().isEmpty() ? swaggerConfigurationProerties.getTitle() : docketInfo.getTitle()).description(docketInfo.getDescription().isEmpty() ? swaggerConfigurationProerties.getDescription() : docketInfo.getDescription()).version(docketInfo.getVersion().isEmpty() ? swaggerConfigurationProerties.getVersion() : docketInfo.getVersion()).license(docketInfo.getLicense().isEmpty() ? swaggerConfigurationProerties.getLicense() : docketInfo.getLicense()).licenseUrl(docketInfo.getLicenseUrl().isEmpty() ? swaggerConfigurationProerties.getLicenseUrl() : docketInfo.getLicenseUrl()).contact(new Contact(docketInfo.getContact().getName().isEmpty() ? swaggerConfigurationProerties.getContact().getName() : docketInfo.getContact().getName(), docketInfo.getContact().getUrl().isEmpty() ? swaggerConfigurationProerties.getContact().getUrl() : docketInfo.getContact().getUrl(), docketInfo.getContact().getEmail().isEmpty() ? swaggerConfigurationProerties.getContact().getEmail() : docketInfo.getContact().getEmail())).termsOfServiceUrl(docketInfo.getTermsOfServiceUrl().isEmpty() ? swaggerConfigurationProerties.getTermsOfServiceUrl() : docketInfo.getTermsOfServiceUrl()).build();
    }

    private List<Docket> createRestApiWithoutDocket(SwaggerConfigurationProerties swaggerConfigurationProerties, ConfigurableBeanFactory configurableBeanFactory, List<Docket> docketList) {
        ApiInfo apiInfo = new ApiInfoBuilder().title(swaggerConfigurationProerties.getTitle()).description(swaggerConfigurationProerties.getDescription()).version(swaggerConfigurationProerties.getVersion()).license(swaggerConfigurationProerties.getLicense()).licenseUrl(swaggerConfigurationProerties.getLicenseUrl()).contact(new Contact(swaggerConfigurationProerties.getContact().getName(), swaggerConfigurationProerties.getContact().getUrl(), swaggerConfigurationProerties.getContact().getEmail())).termsOfServiceUrl(swaggerConfigurationProerties.getTermsOfServiceUrl()).build();
        if (swaggerConfigurationProerties.getBasePath().isEmpty()) {
            swaggerConfigurationProerties.getBasePath().add("/**");
        }
        ArrayList<Predicate> basePath = new ArrayList<Predicate>();
        for (String string : swaggerConfigurationProerties.getBasePath()) {
            basePath.add(PathSelectors.ant((String)string));
        }
        ArrayList excludePath = Lists.newArrayList();
        for (String path : swaggerConfigurationProerties.getExcludePath()) {
            excludePath.add(PathSelectors.ant((String)path));
        }
        Docket docket = new Docket(DocumentationType.SWAGGER_2).host(swaggerConfigurationProerties.getHost()).apiInfo(apiInfo).securitySchemes(Collections.singletonList(this.apiKey())).securityContexts(Collections.singletonList(this.securityContext())).globalOperationParameters(this.buildGlobalOperationParametersFromSwaggerConfigurationProerties(swaggerConfigurationProerties.getGlobalOperationParameters()));
        if (!swaggerConfigurationProerties.getApplyDefaultResponseMessages().booleanValue()) {
            this.buildGlobalResponseMessage(swaggerConfigurationProerties, docket);
        }
        Docket docket2 = docket.select().apis(RequestHandlerSelectors.basePackage((String)swaggerConfigurationProerties.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or((Iterable)excludePath)), (Predicate)Predicates.or(basePath))).build();
        Class[] array = new Class[swaggerConfigurationProerties.getIgnoredParameterTypes().size()];
        Class[] ignoredParameterTypes = swaggerConfigurationProerties.getIgnoredParameterTypes().toArray(array);
        docket2.ignoredParameterTypes(ignoredParameterTypes);
        configurableBeanFactory.registerSingleton("defaultDocket", (Object)docket2);
        docketList.add(docket2);
        return docketList;
    }

    private ApiKey apiKey() {
        return new ApiKey(this.swaggerConfigurationProerties().getAuthorization().getName(), this.swaggerConfigurationProerties().getAuthorization().getKeyName(), ApiKeyVehicle.HEADER.getValue());
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)this.swaggerConfigurationProerties().getAuthorization().getAuthRegex())).build();
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return Collections.singletonList(SecurityReference.builder().reference(this.swaggerConfigurationProerties().getAuthorization().getName()).scopes(authorizationScopes).build());
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private List<Parameter> buildGlobalOperationParametersFromSwaggerConfigurationProerties(List<SwaggerConfigurationProerties.GlobalOperationParameter> globalOperationParameters) {
        ArrayList parameters = Lang.list((Object[])new Parameter[0]);
        if (Objects.isNull(globalOperationParameters)) {
            return parameters;
        }
        for (SwaggerConfigurationProerties.GlobalOperationParameter globalOperationParameter : globalOperationParameters) {
            parameters.add(new ParameterBuilder().name(globalOperationParameter.getName()).description(globalOperationParameter.getDescription()).modelRef((ModelReference)new ModelRef(globalOperationParameter.getModelRef())).parameterType(globalOperationParameter.getParameterType()).required(Boolean.parseBoolean(globalOperationParameter.getRequired())).build());
        }
        return parameters;
    }

    private List<Parameter> assemblyGlobalOperationParameters(List<SwaggerConfigurationProerties.GlobalOperationParameter> globalOperationParameters, List<SwaggerConfigurationProerties.GlobalOperationParameter> docketOperationParameters) {
        if (Objects.isNull(docketOperationParameters) || docketOperationParameters.isEmpty()) {
            return this.buildGlobalOperationParametersFromSwaggerConfigurationProerties(globalOperationParameters);
        }
        Set docketNames = docketOperationParameters.stream().map(SwaggerConfigurationProerties.GlobalOperationParameter::getName).collect(Collectors.toSet());
        ArrayList resultOperationParameters = Lang.list((Object[])new SwaggerConfigurationProerties.GlobalOperationParameter[0]);
        if (Objects.nonNull(globalOperationParameters)) {
            for (SwaggerConfigurationProerties.GlobalOperationParameter parameter : globalOperationParameters) {
                if (docketNames.contains(parameter.getName())) continue;
                resultOperationParameters.add(parameter);
            }
        }
        resultOperationParameters.addAll(docketOperationParameters);
        return this.buildGlobalOperationParametersFromSwaggerConfigurationProerties(resultOperationParameters);
    }

    private void buildGlobalResponseMessage(SwaggerConfigurationProerties swaggerConfigurationProerties, Docket docketForBuilder) {
        SwaggerConfigurationProerties.GlobalResponseMessage globalResponseMessages = swaggerConfigurationProerties.getGlobalResponseMessage();
        List<ResponseMessage> postResponseMessages = this.getResponseMessageList(globalResponseMessages.getPost());
        List<ResponseMessage> getResponseMessages = this.getResponseMessageList(globalResponseMessages.getGet());
        List<ResponseMessage> putResponseMessages = this.getResponseMessageList(globalResponseMessages.getPut());
        List<ResponseMessage> patchResponseMessages = this.getResponseMessageList(globalResponseMessages.getPatch());
        List<ResponseMessage> deleteResponseMessages = this.getResponseMessageList(globalResponseMessages.getDelete());
        List<ResponseMessage> headResponseMessages = this.getResponseMessageList(globalResponseMessages.getHead());
        List<ResponseMessage> optionsResponseMessages = this.getResponseMessageList(globalResponseMessages.getOptions());
        List<ResponseMessage> trackResponseMessages = this.getResponseMessageList(globalResponseMessages.getTrace());
        docketForBuilder.useDefaultResponseMessages(swaggerConfigurationProerties.getApplyDefaultResponseMessages().booleanValue()).globalResponseMessage(RequestMethod.POST, postResponseMessages).globalResponseMessage(RequestMethod.GET, getResponseMessages).globalResponseMessage(RequestMethod.PUT, putResponseMessages).globalResponseMessage(RequestMethod.PATCH, patchResponseMessages).globalResponseMessage(RequestMethod.DELETE, deleteResponseMessages).globalResponseMessage(RequestMethod.HEAD, headResponseMessages).globalResponseMessage(RequestMethod.OPTIONS, optionsResponseMessages).globalResponseMessage(RequestMethod.TRACE, trackResponseMessages);
    }

    private List<ResponseMessage> getResponseMessageList(List<SwaggerConfigurationProerties.GlobalResponseMessageBody> globalResponseMessageBodyList) {
        ArrayList responseMessages = Lang.list((Object[])new ResponseMessage[0]);
        for (SwaggerConfigurationProerties.GlobalResponseMessageBody globalResponseMessageBody : globalResponseMessageBodyList) {
            ResponseMessageBuilder responseMessageBuilder = new ResponseMessageBuilder();
            responseMessageBuilder.code(globalResponseMessageBody.getCode()).message(globalResponseMessageBody.getMessage());
            if (!StringUtils.isEmpty((Object)globalResponseMessageBody.getModelRef())) {
                responseMessageBuilder.responseModel((ModelReference)new ModelRef(globalResponseMessageBody.getModelRef()));
            }
            responseMessages.add(responseMessageBuilder.build());
        }
        return responseMessages;
    }
}

