/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.captcha;

import com.chinare.axe.captcha.CaptchaGener;
import com.chinare.axe.captcha.DefaultCaptchaGener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.nutz.lang.random.R;

public class ImageVerification {
    private int imageVerificationLength = 4;
    private String verifyCode = "";
    private CaptchaGener captchaGener = new DefaultCaptchaGener();

    public void setImageVerificationLength(int imageVerificationLength) {
        this.imageVerificationLength = imageVerificationLength;
    }

    public ImageVerification() {
    }

    public ImageVerification(int imageVerificationLength, CaptchaGener captchaGener) {
        this.imageVerificationLength = imageVerificationLength;
        this.captchaGener = captchaGener;
    }

    public BufferedImage creatImage() {
        int i;
        int width = 20 * this.imageVerificationLength + 20;
        int height = 38;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        g.setColor(this.getRandColor(200, 250));
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Comic Sans MS", 1, 25));
        for (i = 0; i < 1023; ++i) {
            g.setColor(this.getRandColor(140, 255));
            int x = R.random((int)0, (int)width);
            int y = R.random((int)0, (int)height);
            int xl = R.random((int)0, (int)100);
            int yl = R.random((int)0, (int)100);
            Graphics2D g1 = (Graphics2D)g;
            g1.setStroke(new BasicStroke(3.0f));
            g1.drawLine(x, y, x + xl, y + yl);
        }
        this.verifyCode = this.captchaGener.gen(this.imageVerificationLength);
        for (i = 0; i < this.imageVerificationLength; ++i) {
            String rand = this.verifyCode.charAt(i) + "";
            g.setColor(this.getRandColor(20, 130));
            g.drawString(rand, 20 * i + 10, 25 + this.getRandInt(-5, 5));
        }
        g.dispose();
        return image;
    }

    public Color getRandColor(int b, int e) {
        if (b > 255) {
            b = 255;
        }
        if (e > 255) {
            e = 255;
        }
        int rc = this.getRandInt(b, e);
        int gc = this.getRandInt(b, e);
        int bc = this.getRandInt(b, e);
        return new Color(rc, gc, bc);
    }

    public int getRandInt(int b, int e) {
        if (b > e) {
            int temp = e;
            e = b;
            b = temp;
        }
        return b + R.random((int)0, (int)(e - b));
    }

    public String getVerifyCode() {
        return this.verifyCode;
    }

    public void setCaptchaGener(CaptchaGener captchaGener) {
        this.captchaGener = captchaGener;
    }
}

