/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe.apm;

import com.chinare.axe.apm.APM;
import com.chinare.axe.apm.APMAppender;
import com.chinare.axe.apm.URLProvider;
import com.chinare.axe.apm.UserCollector;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.nutz.lang.Stopwatch;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.annotation.Async;

@Aspect
public class APMInterceptor {
    APMAppender appender;
    UserCollector collector;
    URLProvider urlProvider;

    public APMInterceptor(APMAppender appender, UserCollector collector, URLProvider urlProvider) {
        this.appender = appender;
        this.collector = collector;
        this.urlProvider = urlProvider;
    }

    public APM getApm(JoinPoint joinPoint) {
        MethodSignature joinPointObject = (MethodSignature)joinPoint.getSignature();
        Method method = joinPointObject.getMethod();
        boolean flag = method.isAnnotationPresent(APM.class);
        if (flag) {
            return method.getAnnotation(APM.class);
        }
        APM classAnnotation = (APM)AnnotationUtils.findAnnotation(joinPointObject.getMethod().getDeclaringClass(), APM.class);
        if (classAnnotation != null) {
            return classAnnotation;
        }
        return null;
    }

    @Around(value="@within(com.chinare.axe.apm.APM)|| @annotation(com.chinare.axe.apm.APM)")
    public Object filter(ProceedingJoinPoint point) throws Throwable {
        APM log = this.getApm((JoinPoint)point);
        Object[] args = point.getArgs();
        Object obj = null;
        long duration = 0L;
        boolean exception = false;
        try {
            Stopwatch stopwatch = Stopwatch.beginNano();
            obj = point.proceed();
            stopwatch.stop();
            duration = stopwatch.getDuration();
        }
        catch (Throwable e) {
            exception = true;
            throw e;
        }
        finally {
            this.log(this.appender.collect(this.urlProvider.provide(), this.collector.collector(), log, args, obj, duration, exception));
        }
        return obj;
    }

    @Async
    public void log(APMAppender.APMLog log) {
        this.appender.append(log);
    }
}

