/*
 * Decompiled with CFR 0.152.
 */
package com.chinare.axe;

import java.util.Iterator;
import java.util.Map;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.util.NutMap;

public class Result {
    private NutMap data = new NutMap();
    private OperationState operationState = OperationState.SUCCESS;
    private Object[] errors;

    public static Result exception() {
        return Result.me().setOperationState(OperationState.EXCEPTION);
    }

    public static Result exception(Exception e) {
        return Result.exception(e.getMessage());
    }

    public static Result exception(String msg) {
        return Result.exception().setErrors(msg);
    }

    public static Result fail(Object ... reason) {
        return Result.me().setOperationState(OperationState.FAIL).setErrors(reason);
    }

    public static Result me() {
        return new Result();
    }

    public static Result success() {
        return Result.me().setOperationState(OperationState.SUCCESS);
    }

    public static Result success(Map data) {
        return Result.success().setData(data);
    }

    public Object[] getErrors() {
        return this.errors;
    }

    public Result setErrors(Object ... errors) {
        this.errors = errors;
        return this;
    }

    public Result() {
    }

    public Result(OperationState operationState, Map data) {
        this.operationState = operationState;
        this.data = NutMap.WRAP((Map)data);
    }

    public Result addData(Map<String, Object> data) {
        Iterator<String> iterator = data.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            this.data.put((Object)key, data.get(key));
        }
        return this;
    }

    public Result addData(String key, Object object) {
        if (this.data == null) {
            this.data = new NutMap();
        }
        this.data.put((Object)key, object);
        return this;
    }

    public Result clear() {
        this.operationState = OperationState.SUCCESS;
        if (this.data != null) {
            this.data.clear();
        }
        return this;
    }

    public NutMap getData() {
        return this.data;
    }

    public OperationState getOperationState() {
        return this.operationState;
    }

    public boolean isSuccess() {
        return this.getOperationState() == OperationState.SUCCESS;
    }

    public Result setData(Map<String, Object> data) {
        this.data = NutMap.WRAP(data);
        return this;
    }

    public Result setOperationState(OperationState operationState) {
        this.operationState = operationState;
        return this;
    }

    public String toString() {
        return Json.toJson((Object)this, (JsonFormat)JsonFormat.forLook());
    }

    public static enum OperationState {
        SUCCESS("\u6210\u529f", 0),
        FAIL("\u5931\u8d25", 1),
        EXCEPTION("\u5f02\u5e38\u53d1\u751f", -1);

        String mgs;
        int code;

        private OperationState(String mgs, int code) {
            this.mgs = mgs;
            this.code = code;
        }

        public String getMgs() {
            return this.mgs;
        }

        public int getCode() {
            return this.code;
        }
    }
}

