/*
 * Decompiled with CFR 0.152.
 */
package cn.com.analysys.javasdk;

import cn.com.analysys.javasdk.AnalysysException;
import cn.com.analysys.javasdk.AnalysysLogger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;

public class ValidHandle {
    private static boolean delNotValidParam = true;
    private static ObjectMapper egJsonMapper = ValidHandle.getJsonObjectMapper();
    private static final Pattern KEY_PATTERN = Pattern.compile("^((?!^xwhat$|^xwhen$|^xwho$|^appid$|^xcontext$|^\\$lib$|^\\$lib_version$)^[$a-zA-Z][$a-zA-Z0-9_]{0,98})$", 2);
    private static final Pattern KEY_PATTERN_CONTEXT = Pattern.compile("^((?!^xwhat$|^xwhen$|^xwho$|^appid$|^xcontext$|^\\$lib$|^\\$lib_version$)^[$a-zA-Z][$a-zA-Z0-9_]{0,124})$", 2);

    public static void setDelNotValidParam(boolean delNotValidParam) {
        ValidHandle.delNotValidParam = delNotValidParam;
    }

    public static ObjectMapper getEgJsonMapper() {
        return egJsonMapper;
    }

    public static void checkParam(String eventName, Map<String, Object> properties) throws AnalysysException {
        if (properties == null) {
            properties = new HashMap<String, Object>(1);
        }
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> property = it.next();
            if (property.getKey() == null || property.getKey().toString().trim().length() == 0) {
                AnalysysLogger.print(String.format("Warn: The property key is null or empty.", new Object[0]));
                if (property.getKey() == null) {
                    it.remove();
                    continue;
                }
            }
            if (property.getValue() == null) {
                AnalysysLogger.print(String.format("Warn: The property %s value is null.", property.getKey()));
                continue;
            }
            try {
                if (property == null) continue;
                ValidHandle.checkParamImpl(eventName, property);
            }
            catch (AnalysysException e) {
                if (delNotValidParam) {
                    it.remove();
                    AnalysysLogger.print(e.getMessage());
                    continue;
                }
                throw e;
            }
        }
    }

    private static boolean checkParamImpl(String eventName, Map.Entry<String, Object> property) throws AnalysysException {
        int valueLength = 8192;
        int valueWarnLength = 255;
        int keyLength = 99;
        int valueListLen = 100;
        String piEventName = "$profile_increment";
        String paEventName = "$profile_append";
        String puEventName = "$profile_unset";
        if (property.getKey().length() > keyLength) {
            AnalysysLogger.print(String.format("Warn: The property key %s is too long, max length is %s.", property.getKey(), keyLength));
        }
        if (!KEY_PATTERN_CONTEXT.matcher(property.getKey()).matches()) {
            AnalysysLogger.print(String.format("Warn: The property key %s is invalid.", property.getKey()));
        }
        if (!(property.getValue() instanceof Number || property.getValue() instanceof Boolean || property.getValue() instanceof String || property.getValue().getClass().isArray() || property.getValue() instanceof List)) {
            AnalysysLogger.print(String.format("Warn: The property %s is not Number, String, Boolean, List<String>.", property.getKey()));
        }
        if (property.getValue() instanceof String && property.getValue().toString().length() == 0 && !puEventName.equals(eventName)) {
            AnalysysLogger.print(String.format("Warn: The property %s String value is null or empty.", property.getKey()));
        }
        if (property.getValue() instanceof String && property.getValue().toString().length() > valueWarnLength) {
            AnalysysLogger.print(String.format("Warn: The property %s String value is too long, max length is %s.", property.getKey(), valueWarnLength));
        }
        if (property.getValue() instanceof String && property.getValue().toString().length() > valueLength) {
            property.setValue(property.getValue().toString().substring(0, valueLength - 1) + "$");
        }
        if (property.getValue() instanceof List) {
            List list;
            List valueList = (List)property.getValue();
            if (valueList.size() > valueListLen) {
                valueList = valueList.subList(0, valueListLen);
                property.setValue(valueList);
                AnalysysLogger.print(String.format("Warn: The property %s, max number should be %s.", property.getKey(), valueListLen));
            }
            if ((list = (List)property.getValue()) != null) {
                if (list.size() == 0) {
                    AnalysysLogger.print(String.format("Warn: The property %s is empty.", property.getKey()));
                }
                ListIterator<String> iterator = list.listIterator();
                while (iterator.hasNext()) {
                    Object vals = iterator.next();
                    if (vals == null) continue;
                    if (!(vals instanceof String)) {
                        AnalysysLogger.print(String.format("The property %s should be a list of String.", property.getKey()));
                    }
                    if (((String)vals).length() > valueWarnLength) {
                        AnalysysLogger.print(String.format("Warn: The property %s some value is too long, max length is %s.", property.getKey(), valueWarnLength));
                    }
                    if (((String)vals).length() <= valueLength) continue;
                    iterator.set(vals.toString().substring(0, valueLength - 1) + "$");
                }
            }
        }
        if (piEventName.equals(eventName) && !(property.getValue() instanceof Number)) {
            AnalysysLogger.print(String.format("The property value of %s should be a Number.", property.getKey()));
        }
        if (paEventName.equals(eventName) && !(property.getValue() instanceof List) && !property.getValue().getClass().isArray()) {
            AnalysysLogger.print(String.format("The property value of %s should be a List<String>.", property.getKey()));
        }
        return true;
    }

    public static void checkProperty(String distinctId, String eventName, Map<String, Object> properties, int commProLen) throws AnalysysException {
        String aliasEventName = "$alias";
        String originalId = "$original_id";
        int eventNameLen = 99;
        int idLength = 255;
        if (properties == null) {
            properties = new HashMap<String, Object>(1);
        }
        if (distinctId == null || distinctId.length() == 0) {
            throw new AnalysysException(String.format("aliasId %s is empty.", distinctId));
        }
        if (distinctId.toString().length() > idLength) {
            throw new AnalysysException(String.format("aliasId %s is too long, max length is %s.", distinctId, idLength));
        }
        if (aliasEventName.equals(eventName)) {
            if (properties.get(originalId) == null || properties.get(originalId).toString().length() == 0) {
                throw new AnalysysException(String.format("original_id %s is empty.", properties.get(originalId)));
            }
            if (properties.get(originalId).toString().length() > idLength) {
                throw new AnalysysException(String.format("original_id %s is too long, max length is %s.", properties.get(originalId), idLength));
            }
        }
        if (eventName != null) {
            if (eventName.length() == 0) {
                AnalysysLogger.print("EventName is empty.");
            }
            if (eventName.length() > eventNameLen) {
                AnalysysLogger.print(String.format("EventName %s is too long, max length is %s.", eventName, eventNameLen));
            }
            if (!KEY_PATTERN.matcher(eventName).matches()) {
                AnalysysLogger.print(String.format("EventName %s is invalid.", eventName));
            }
        } else {
            AnalysysLogger.print("EventName is null.");
        }
        ValidHandle.checkParam(eventName, properties);
    }

    private static ObjectMapper getJsonObjectMapper() {
        ObjectMapper jsonObjectMapper = new ObjectMapper();
        jsonObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return jsonObjectMapper;
    }
}

