/*
 * Decompiled with CFR 0.152.
 */
package cn.com.analysys.javasdk;

import cn.com.analysys.javasdk.AnalysysException;
import cn.com.analysys.javasdk.AnalysysLogger;
import cn.com.analysys.javasdk.Collecter;
import cn.com.analysys.javasdk.MessageSender;
import cn.com.analysys.javasdk.ValidHandle;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SyncCollecter
implements Collecter {
    private final String serverUrl;
    private final boolean interrupt;
    private boolean debug;

    public SyncCollecter(String serverUrl) {
        this(serverUrl, false);
    }

    public SyncCollecter(String serverUrl, boolean interrupt) {
        if (serverUrl == null || serverUrl.trim().length() == 0) {
            throw new RuntimeException("Server URL is empty");
        }
        if (serverUrl.contains("/up")) {
            serverUrl = serverUrl.substring(0, serverUrl.indexOf("/up"));
        }
        this.serverUrl = serverUrl + "/up";
        this.interrupt = interrupt;
    }

    @Override
    public boolean send(Map<String, Object> egCollectMessage) {
        String jsonData = null;
        ArrayList<Map<String, Object>> egMsgList = new ArrayList<Map<String, Object>>();
        try {
            egMsgList.add(egCollectMessage);
            jsonData = ValidHandle.getEgJsonMapper().writeValueAsString(egMsgList);
            HashMap<String, String> headParam = new HashMap<String, String>(1);
            if (this.debug) {
                AnalysysLogger.print(String.format("Send message to server: %s data: %s", this.serverUrl, jsonData));
            }
            String retMsg = new MessageSender(this.serverUrl, headParam, jsonData).send();
            if (this.debug) {
                AnalysysLogger.print(String.format("Send message success,response: %s", retMsg));
            }
            return true;
        }
        catch (JsonProcessingException e) {
            AnalysysLogger.print("Json Serialization Fail: " + egMsgList);
            if (this.interrupt) {
                throw new RuntimeException("Json Serialize Error: ", e);
            }
            AnalysysLogger.print("Json Serialize Error: " + (Object)((Object)e));
        }
        catch (AnalysysException e) {
            if (this.interrupt) {
                throw new RuntimeException("Upload Data Error: ", e);
            }
            AnalysysLogger.print("Upload Data Error: " + e);
        }
        catch (IOException e) {
            if (this.interrupt) {
                throw new RuntimeException("Connect Server Error: ", e);
            }
            AnalysysLogger.print("Connect Server Error: " + e);
        }
        catch (Exception e) {
            AnalysysLogger.print("Sync Send Data Error: " + e);
        }
        return false;
    }

    @Override
    public void upload() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void debug(boolean debug) {
        this.debug = debug;
    }
}

