/*
 * Decompiled with CFR 0.152.
 */
package cn.com.analysys.javasdk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class LogWriter {
    private static volatile Map<String, FileOutputStream> streamCachedMap = new HashMap<String, FileOutputStream>();
    private static volatile Map<String, AtomicInteger> streamNumberMap = new HashMap<String, AtomicInteger>();
    private static final int MIN_CATCH_NUM = 1;
    private static final String FILENAME_TEMPLET = "datas_$DATEPATTEN.log";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean write(String logFolder, String logFileTime, String value, FileOutputStream lockstream) throws IOException {
        FileOutputStream stream = LogWriter.getFileStream(logFolder, logFileTime);
        streamNumberMap.get(logFileTime).incrementAndGet();
        if (stream == null) {
            return false;
        }
        FileOutputStream fileOutputStream = stream;
        synchronized (fileOutputStream) {
            if (!streamCachedMap.containsKey(logFileTime)) {
                return false;
            }
            FileLock lock = null;
            try {
                FileChannel channel = null;
                channel = lockstream != null ? lockstream.getChannel() : stream.getChannel();
                if (channel == null || !channel.isOpen()) {
                    boolean bl = false;
                    return bl;
                }
                lock = channel.lock();
                stream.write(value.getBytes("UTF-8"));
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                streamNumberMap.get(logFileTime).decrementAndGet();
                if (lock != null) {
                    lock.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileOutputStream getFileStream(String logFolder, String logFileTime) {
        if (!logFolder.endsWith(File.separator)) {
            logFolder = logFolder.concat(File.separator);
        }
        if (!new File(logFolder).exists()) {
            new File(logFolder).mkdirs();
        }
        String logFilePath = logFolder.concat(FILENAME_TEMPLET.replaceAll("\\$DATEPATTEN", logFileTime));
        Map<String, FileOutputStream> map = streamCachedMap;
        synchronized (map) {
            if (streamCachedMap.size() > 1) {
                LogWriter.removeStream(logFileTime);
            }
            if (!streamCachedMap.containsKey(logFileTime)) {
                try {
                    FileOutputStream out = new FileOutputStream(logFilePath, true);
                    streamCachedMap.put(logFileTime, out);
                    streamNumberMap.put(logFileTime, new AtomicInteger(0));
                }
                catch (FileNotFoundException e) {
                    Object var4_5 = null;
                }
            }
            return streamCachedMap.get(logFileTime);
        }
    }

    private static void removeStream(String logFileTime) {
        Iterator<Map.Entry<String, FileOutputStream>> it = streamCachedMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, FileOutputStream> property = it.next();
            try {
                long cachTime = Long.valueOf(property.getKey());
                long requestTime = Long.valueOf(logFileTime);
                if (requestTime - cachTime < 1L || !streamNumberMap.containsKey(property.getKey()) || streamNumberMap.get(property.getKey()).get() != 0) continue;
                property.getValue().close();
                it.remove();
                streamNumberMap.remove(property.getKey());
            }
            catch (Exception exception) {}
        }
    }

    public static String monitor() {
        StringBuffer bufer = new StringBuffer();
        bufer.append(String.format("Stream Catch Status: %s:%s", streamCachedMap.size(), streamNumberMap.size()));
        for (Map.Entry<String, FileOutputStream> property : streamCachedMap.entrySet()) {
            bufer.append(String.format("    date[%s] num[%s]", property.getKey(), streamNumberMap.get(property.getKey())));
        }
        return bufer.toString();
    }

    public static void close() {
        for (Map.Entry<String, FileOutputStream> property : streamCachedMap.entrySet()) {
            try {
                if (property.getValue() == null) continue;
                property.getValue().close();
            }
            catch (Exception exception) {}
        }
    }
}

