/*
 * Decompiled with CFR 0.152.
 */
package cn.com.analysys.javasdk;

import cn.com.analysys.javasdk.AnalysysLogger;
import cn.com.analysys.javasdk.Collecter;
import cn.com.analysys.javasdk.LogWriter;
import cn.com.analysys.javasdk.ValidHandle;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LogCollecter
implements Collecter {
    private final String linefeed = "\n";
    private final String logFolder;
    private final SimpleDateFormat format;
    private boolean async = false;
    private boolean singleObj = true;
    private static final int RETRY_TIMES = 3;
    private static final int DEFAULT_BATCH_NUM = 20;
    private static final long DEFAULT_BATCH_SEC = 10L;
    private long sendTimer = -1L;
    private List<Map<String, Object>> batchMsgList;
    private FileOutputStream lockstream = null;
    private ExecutorService singleThread;
    private boolean isListen = true;
    private int batchNum;
    private long batchSec;

    public LogCollecter(String logFolder) {
        this(logFolder, GeneralRule.HOUR, false, 20, 10L, true);
    }

    public LogCollecter(String logFolder, boolean async) {
        this(logFolder, GeneralRule.HOUR, async, 20, 10L, true);
    }

    public LogCollecter(String logFolder, GeneralRule rule) {
        this(logFolder, rule, false, 20, 10L, true);
    }

    public LogCollecter(String logFolder, GeneralRule rule, boolean async) {
        this(logFolder, rule, async, 20, 10L, true);
    }

    public LogCollecter(String logFolder, GeneralRule rule, boolean async, int batchNum, long batchSec) {
        this(logFolder, rule, async, batchNum, batchSec, true);
    }

    private LogCollecter(String logFolder, GeneralRule rule, boolean async, int batchNum, long batchSec, boolean singleObj) {
        this.logFolder = logFolder;
        if (!new File(logFolder).exists()) {
            new File(logFolder).mkdirs();
        }
        String lock = "lock";
        if (GeneralRule.DAY.equals((Object)rule)) {
            this.format = new SimpleDateFormat("yyyyMMdd");
            lock = lock.concat("_day");
        } else {
            this.format = new SimpleDateFormat("yyyyMMddHH");
            lock = lock.concat("_hour");
        }
        this.async = async;
        this.singleObj = singleObj;
        this.batchMsgList = new ArrayList<Map<String, Object>>(1);
        if (this.async) {
            this.batchNum = batchNum;
            this.batchSec = batchSec * 1000L;
            this.batchMsgList = new ArrayList<Map<String, Object>>(this.batchNum);
            this.singleThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.init();
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            String lockFileName = logFolder.concat(lock);
            if (!logFolder.endsWith(File.separator)) {
                lockFileName = logFolder.concat(File.separator).concat(lock);
            }
            try {
                if (!new File(lockFileName).exists()) {
                    new File(lockFileName).createNewFile();
                }
                this.lockstream = new FileOutputStream(lockFileName, true);
            }
            catch (Exception e) {
                AnalysysLogger.print("Init LockStream Error: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(Map<String, Object> egCollectMessage) {
        try {
            if (!this.async) {
                ArrayList<Map<String, Object>> egMsgList = new ArrayList<Map<String, Object>>();
                egMsgList.add(egCollectMessage);
                this.dealLog(egMsgList);
            } else {
                List<Map<String, Object>> egMsgList = this.batchMsgList;
                synchronized (egMsgList) {
                    if (this.sendTimer == -1L) {
                        this.sendTimer = System.currentTimeMillis();
                    }
                    this.batchMsgList.add(egCollectMessage);
                }
                if (this.batchMsgList.size() >= this.batchNum) {
                    this.upload();
                }
            }
            return true;
        }
        catch (Exception e) {
            try {
                AnalysysLogger.print("Log Data Error: " + this.serialize(egCollectMessage));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload() {
        List<Map<String, Object>> list = this.batchMsgList;
        synchronized (list) {
            if (this.batchMsgList != null && this.batchMsgList.size() > 0) {
                try {
                    this.dealLog(this.batchMsgList);
                }
                catch (JsonProcessingException e) {
                    AnalysysLogger.print("Json Serialize Error: " + (Object)((Object)e));
                }
                catch (IOException e) {
                    AnalysysLogger.print("Json Serialize Error: " + e);
                }
                finally {
                    this.batchMsgList.clear();
                    if (this.async) {
                        this.resetTimer();
                    }
                }
            }
        }
    }

    private void dealLog(List<Map<String, Object>> batchMsgList) throws JsonGenerationException, JsonMappingException, IOException {
        boolean success = false;
        if (this.singleObj) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (Map<String, Object> map : batchMsgList) {
                String jsonData = this.serialize(map);
                if (++index > 1) {
                    sb.append("\n");
                }
                sb.append(jsonData);
            }
            success = this.dealLog(sb.toString());
        } else {
            String jsonData = this.serialize(batchMsgList);
            success = this.dealLog(jsonData);
        }
        if (!success) {
            AnalysysLogger.print("Error After Retry 3 Times: " + this.serialize(batchMsgList));
        }
    }

    private String serialize(Object obj) throws JsonGenerationException, JsonMappingException, IOException {
        return ValidHandle.getEgJsonMapper().writeValueAsString(obj);
    }

    private boolean dealLog(String jsonData) {
        boolean success = this.write(jsonData);
        if (!success) {
            int total = 3;
            while (!success && total-- > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e1) {
                    AnalysysLogger.print(e1.getMessage());
                }
                success = this.write(jsonData);
            }
        }
        return success;
    }

    private boolean write(String jsonData) {
        try {
            boolean success = LogWriter.write(this.logFolder, this.generalNowTime(), jsonData.concat("\n"), this.lockstream);
            return success;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void flush() {
        this.upload();
    }

    @Override
    public void close() {
        this.flush();
        this.shutdown();
    }

    @Override
    public void debug(boolean debug) {
    }

    private void init() {
        this.singleThread.execute(new Runnable(){

            @Override
            public void run() {
                while (LogCollecter.this.isListen) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e1) {
                        AnalysysLogger.print(e1.getMessage());
                    }
                    if (LogCollecter.this.sendTimer == -1L || System.currentTimeMillis() - LogCollecter.this.sendTimer < LogCollecter.this.batchSec) continue;
                    try {
                        LogCollecter.this.upload();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    private void shutdown() {
        this.isListen = false;
        try {
            LogWriter.close();
            if (this.async) {
                this.singleThread.shutdown();
                this.singleThread.awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            AnalysysLogger.print(e.getMessage());
            this.singleThread = null;
        }
    }

    private void resetTimer() {
        this.sendTimer = -1L;
    }

    public String generalNowTime() {
        return this.format.format(new Date());
    }

    public static enum GeneralRule {
        HOUR,
        DAY;

    }
}

