/*
 * Decompiled with CFR 0.152.
 */
package cn.com.analysys.javasdk;

import cn.com.analysys.javasdk.AnalysysEncoder;
import cn.com.analysys.javasdk.AnalysysException;
import java.io.Closeable;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class MessageSender {
    private final Boolean isEncode;
    private final String serverUrl;
    private final Map<String, String> egHeaderParams;
    private final String jsonData;

    public MessageSender(String serverUrl, Map<String, String> egHeaderParams, String jsonData) {
        this(serverUrl, egHeaderParams, jsonData, true);
    }

    public MessageSender(String serverUrl, Map<String, String> egHeaderParams, String jsonData, Boolean isEncode) {
        this.serverUrl = serverUrl;
        this.egHeaderParams = egHeaderParams;
        this.jsonData = jsonData;
        this.isEncode = isEncode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String send() throws Exception {
        CloseableHttpClient httpclient = null;
        Closeable response = null;
        try {
            httpclient = this.getHttpClient();
            HttpPost egHttpPost = new HttpPost(this.serverUrl);
            egHttpPost.addHeader("User-Agent", "Analysys Java SDK");
            if (this.egHeaderParams != null) {
                for (Map.Entry<String, String> entry : this.egHeaderParams.entrySet()) {
                    egHttpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            StringEntity egRequest = null;
            if (this.isEncode.booleanValue()) {
                egRequest = new StringEntity(AnalysysEncoder.encode(AnalysysEncoder.compress(this.jsonData)));
            } else {
                egRequest = new StringEntity(this.jsonData);
                egRequest.setContentType("application/json");
            }
            egRequest.setContentEncoding("UTF-8");
            egHttpPost.setEntity(egRequest);
            egHttpPost.setConfig(this.getHttpConfig());
            response = httpclient.execute(egHttpPost);
            int httpStatusCode = response.getStatusLine().getStatusCode();
            int minCode = 200;
            int maxCode = 300;
            String message = EntityUtils.toString(response.getEntity(), "utf-8");
            try {
                message = AnalysysEncoder.uncompress(AnalysysEncoder.decode(message));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.printLog(message, this.jsonData);
            if (httpStatusCode < minCode || httpStatusCode >= maxCode) throw new AnalysysException(message);
            if (message != null && message.contains("\"code\":200")) {
                String string = message;
                return string;
            }
            throw new AnalysysException(message);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
    }

    private void printLog(String message, String jsonData) {
        if (message != null && !message.contains("\"code\":200")) {
            System.out.println("Data Upload Fail: " + jsonData);
        }
    }

    private CloseableHttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    private RequestConfig getHttpConfig() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(20000).build();
        return requestConfig;
    }
}

