/*
 * Decompiled with CFR 0.152.
 */
package cn.com.analysys.javasdk;

import cn.com.analysys.javasdk.AnalysysException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;

public class ValidHandle {
    private static boolean delNotValidParam = false;
    private static ObjectMapper egJsonMapper = ValidHandle.getJsonObjectMapper();
    private static final Pattern KEY_PATTERN = Pattern.compile("^((?!^xwhat$|^xwhen$|^xwho$|^appid$|^xcontext$|^\\$lib$|^\\$lib_version$)^[$a-zA-Z][$a-zA-Z0-9_]{0,98})$", 2);
    private static final Pattern KEY_PATTERN_CONTEXT = Pattern.compile("^((?!^xwhat$|^xwhen$|^xwho$|^appid$|^xcontext$|^\\$lib$|^\\$lib_version$)^[$a-zA-Z][$a-zA-Z0-9_]{0,124})$", 2);

    public static void setDelNotValidParam(boolean delNotValidParam) {
        ValidHandle.delNotValidParam = delNotValidParam;
    }

    public static ObjectMapper getEgJsonMapper() {
        return egJsonMapper;
    }

    public static void checkParam(String eventName, Map<String, Object> properties) throws AnalysysException {
        if (properties == null) {
            properties = new HashMap<String, Object>(1);
        }
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> property = it.next();
            if (property.getValue() == null) continue;
            try {
                ValidHandle.checkParamImpl(eventName, property);
            }
            catch (AnalysysException e) {
                if (delNotValidParam) {
                    it.remove();
                    System.out.println(e);
                    continue;
                }
                throw e;
            }
        }
    }

    private static boolean checkParamImpl(String eventName, Map.Entry<String, Object> property) throws AnalysysException {
        int valueLength = 8192;
        int valueWarnLength = 255;
        int keyLength = 125;
        int valueListLen = 100;
        String piEventName = "$profile_increment";
        String paEventName = "$profile_append";
        if (property.getKey().length() > keyLength) {
            throw new AnalysysException(String.format("The property key %s is too long, max length is %s.", property.getKey(), keyLength));
        }
        if (!KEY_PATTERN_CONTEXT.matcher(property.getKey()).matches()) {
            throw new AnalysysException(String.format("The property key %s is invalid.", property.getKey()));
        }
        if (!(property.getValue() instanceof Number || property.getValue() instanceof Boolean || property.getValue() instanceof String || property.getValue().getClass().isArray() || property.getValue() instanceof List)) {
            throw new AnalysysException(String.format("The property %s is not Number, String, Boolean, List<String>.", property.getKey()));
        }
        if (property.getValue() instanceof String && property.getValue().toString().length() > valueWarnLength) {
            System.out.println(String.format("Warn: The property %s String value is too long, max length is %s.", property.getKey(), valueWarnLength));
        }
        if (property.getValue() instanceof String && property.getValue().toString().length() > valueLength) {
            property.setValue(property.getValue().toString().substring(0, valueLength - 1) + "$");
        }
        if (property.getValue() instanceof List) {
            List valueList = (List)property.getValue();
            if (valueList.size() > valueListLen) {
                valueList = valueList.subList(0, valueListLen);
                property.setValue(valueList);
                System.out.println(String.format("Warn: The property %s, max number should be %s.", property.getKey(), valueListLen));
            }
            List list = (List)property.getValue();
            ListIterator<String> iterator = list.listIterator();
            while (iterator.hasNext()) {
                Object vals = iterator.next();
                if (!(vals instanceof String)) {
                    throw new AnalysysException(String.format("The property %s should be a list of String.", property.getKey()));
                }
                if (((String)vals).length() > valueWarnLength) {
                    System.out.println(String.format("Warn: The property %s some value is too long, max length is %s.", property.getKey(), valueWarnLength));
                }
                if (((String)vals).length() <= valueLength) continue;
                iterator.set(vals.toString().substring(0, valueLength - 1) + "$");
            }
        }
        if (piEventName.equals(eventName) && !(property.getValue() instanceof Number)) {
            throw new AnalysysException(String.format("The property value of %s should be a Number.", property.getKey()));
        }
        if (paEventName.equals(eventName) && !(property.getValue() instanceof List) && !property.getValue().getClass().isArray()) {
            throw new AnalysysException(String.format("The property value of %s should be a List<String>.", property.getKey()));
        }
        return true;
    }

    public static void checkProperty(String distinctId, String eventName, Map<String, Object> properties, int commProLen) throws AnalysysException {
        String aliasEventName = "$alias";
        String profileEventName = "$profile";
        String originalId = "$original_id";
        int eventNameLen = 99;
        int connonParamLen = 5;
        int idLength = 255;
        int totalParamLen = 300;
        if (properties == null) {
            properties = new HashMap<String, Object>(1);
        }
        if (distinctId == null || distinctId.length() == 0) {
            throw new AnalysysException(String.format("aliasId %s is empty.", distinctId));
        }
        if (distinctId.toString().length() > idLength) {
            throw new AnalysysException(String.format("aliasId %s is too long, max length is %s.", distinctId, idLength));
        }
        if (aliasEventName.equals(eventName)) {
            if (properties.get(originalId) == null || properties.get(originalId).toString().length() == 0) {
                throw new AnalysysException(String.format("original_id %s is empty.", properties.get(originalId)));
            }
            if (properties.get(originalId).toString().length() > idLength) {
                throw new AnalysysException(String.format("original_id %s is too long, max length is %s.", properties.get(originalId), idLength));
            }
        }
        if (eventName == null || eventName.length() == 0) {
            throw new AnalysysException(String.format("EventName %s is empty.", eventName));
        }
        if (eventName.length() > eventNameLen) {
            throw new AnalysysException(String.format("EventName %s is too long, max length is %s.", eventName, eventNameLen));
        }
        if (!KEY_PATTERN.matcher(eventName).matches()) {
            throw new AnalysysException(String.format("EventName %s is invalid.", eventName));
        }
        if (!eventName.startsWith(profileEventName) && !eventName.startsWith(aliasEventName)) {
            if (properties.entrySet().size() + commProLen + connonParamLen > totalParamLen) {
                ValidHandle.subProperties(properties, totalParamLen - connonParamLen - commProLen);
                System.out.println(String.format("Warn: Too many attributes. max number is %s.", totalParamLen - commProLen - connonParamLen));
            }
        } else if (properties.entrySet().size() + connonParamLen > totalParamLen) {
            ValidHandle.subProperties(properties, totalParamLen - connonParamLen);
            System.out.println(String.format("Warn: Too many attributes. max number is %s.", totalParamLen - connonParamLen));
        }
        ValidHandle.checkParam(eventName, properties);
    }

    private static void subProperties(Map<String, Object> properties, int len) {
        try {
            int index = 0;
            Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
            while (it.hasNext()) {
                it.next();
                if (++index <= len) continue;
                it.remove();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ObjectMapper getJsonObjectMapper() {
        ObjectMapper jsonObjectMapper = new ObjectMapper();
        jsonObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return jsonObjectMapper;
    }
}

