/*
 * Decompiled with CFR 0.152.
 */
package cn.com.analysys.javasdk;

import cn.com.analysys.javasdk.AnalysysException;
import cn.com.analysys.javasdk.Collecter;
import cn.com.analysys.javasdk.EventName;
import cn.com.analysys.javasdk.MessageSender;
import cn.com.analysys.javasdk.ValidHandle;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BatchCollecter
implements Collecter {
    private long sendTimer = -1L;
    private boolean isListen = true;
    private final String serverUrl;
    private static final int DEFAULT_BATCH_NUM = 20;
    private static final long DEFAULT_BATCH_SEC = 10L;
    private final int batchNum;
    private final long batchSec;
    private final boolean interrupt;
    private final List<Map<String, Object>> batchMsgList;
    private final ExecutorService singleThread;
    private boolean debug;

    public BatchCollecter(String serverUrl) {
        this(serverUrl, 20, 10L);
    }

    public BatchCollecter(String serverUrl, boolean interrupt) {
        this(serverUrl, 20, 10L, interrupt);
    }

    public BatchCollecter(String serverUrl, int batchNum) {
        this(serverUrl, batchNum, 10L);
    }

    public BatchCollecter(String serverUrl, int batchNum, long batchSec) {
        this(serverUrl, batchNum, batchSec, false);
    }

    public BatchCollecter(String serverUrl, int batchNum, long batchSec, boolean interrupt) {
        if (serverUrl == null || serverUrl.trim().length() == 0) {
            throw new RuntimeException("Server URL is empty");
        }
        if (serverUrl.contains("/up")) {
            serverUrl = serverUrl.substring(0, serverUrl.indexOf("/up"));
        }
        this.serverUrl = serverUrl + "/up";
        this.interrupt = interrupt;
        this.batchNum = batchNum;
        this.batchSec = batchSec * 1000L;
        this.batchMsgList = new ArrayList<Map<String, Object>>(this.batchNum);
        this.singleThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.init();
    }

    private void init() {
        this.singleThread.execute(new Runnable(){

            @Override
            public void run() {
                while (BatchCollecter.this.isListen) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (BatchCollecter.this.sendTimer == -1L || System.currentTimeMillis() - BatchCollecter.this.sendTimer < BatchCollecter.this.batchSec) continue;
                    try {
                        BatchCollecter.this.upload();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(Map<String, Object> egCollectMessage) {
        List<Map<String, Object>> list = this.batchMsgList;
        synchronized (list) {
            if (this.sendTimer == -1L) {
                this.sendTimer = System.currentTimeMillis();
            }
            this.batchMsgList.add(egCollectMessage);
            String xWhat = "xwhat";
            if (this.batchMsgList.size() >= this.batchNum || EventName.ALIAS.getValue().equals(egCollectMessage.get(xWhat))) {
                this.upload();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload() {
        String jsonData = null;
        List<Map<String, Object>> list = this.batchMsgList;
        synchronized (list) {
            if (this.batchMsgList != null && this.batchMsgList.size() > 0) {
                try {
                    jsonData = ValidHandle.getEgJsonMapper().writeValueAsString(this.batchMsgList);
                    HashMap<String, String> headParam = new HashMap<String, String>(1);
                    if (this.debug) {
                        System.out.println(String.format("Send message to server: %s \ndata: %s", this.serverUrl, jsonData));
                    }
                    String retMsg = new MessageSender(this.serverUrl, headParam, jsonData).send();
                    if (this.debug) {
                        System.out.println(String.format("Send message success,response: %s", retMsg));
                    }
                }
                catch (JsonProcessingException e) {
                    if (this.interrupt) {
                        this.shutdown();
                        throw new RuntimeException("Json Serialize Error", e);
                    }
                    System.out.println("Json Serialize Error" + (Object)((Object)e));
                }
                catch (AnalysysException e) {
                    if (this.interrupt) {
                        this.shutdown();
                        throw new RuntimeException("Upload Data Error", e);
                    }
                    System.out.println("Upload Data Error" + e);
                }
                catch (IOException e) {
                    if (this.interrupt) {
                        this.shutdown();
                        throw new RuntimeException("Connect Server Error", e);
                    }
                    System.out.println("Connect Server Error" + e);
                }
                catch (Exception e) {
                    System.out.println("Send Data Error" + e);
                }
                finally {
                    this.batchMsgList.clear();
                    this.resetTimer();
                }
            }
        }
    }

    @Override
    public void flush() {
        this.upload();
    }

    @Override
    public void close() {
        this.flush();
        this.shutdown();
    }

    private void shutdown() {
        this.isListen = false;
        try {
            this.singleThread.shutdown();
            this.singleThread.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void resetTimer() {
        this.sendTimer = -1L;
    }

    @Override
    public void debug(boolean debug) {
        this.debug = debug;
    }
}

