/*
 * Decompiled with CFR 0.152.
 */
package cn.com.analysys.javasdk;

import cn.com.analysys.javasdk.AnalysysException;
import cn.com.analysys.javasdk.Collecter;
import cn.com.analysys.javasdk.DEBUG;
import cn.com.analysys.javasdk.EventName;
import cn.com.analysys.javasdk.PlatForm;
import cn.com.analysys.javasdk.ValidHandle;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AnalysysJavaSdk {
    private final String SDK_VERSION = "4.0.9";
    private final Collecter collecter;
    private final String appId;
    private final Map<String, Object> egBaseProperties;
    private final Map<String, Object> xcontextSuperProperties;
    private int debugMode = DEBUG.CLOSE.getCode();

    public AnalysysJavaSdk(Collecter collecter, String appId) {
        this(collecter, appId, false);
    }

    public AnalysysJavaSdk(Collecter collecter, String appId, Boolean autoDelParam) {
        this.collecter = collecter;
        this.appId = appId;
        this.egBaseProperties = new HashMap<String, Object>(3);
        this.xcontextSuperProperties = new ConcurrentHashMap<String, Object>();
        ValidHandle.setDelNotValidParam(autoDelParam);
        this.initBaseProperties();
    }

    public void setDebugMode(DEBUG debug) {
        this.debugMode = debug.getCode();
    }

    private boolean isDebug() {
        return this.debugMode == DEBUG.OPENNOSAVE.getCode() || this.debugMode == DEBUG.OPENANDSAVE.getCode();
    }

    public void initBaseProperties() {
        this.egBaseProperties.clear();
        this.egBaseProperties.put("$lib", PlatForm.Java.getValue());
        this.egBaseProperties.put("$lib_version", "4.0.9");
    }

    public void registerSuperProperties(Map<String, Object> params) throws AnalysysException {
        int num = 100;
        if (params.entrySet().size() > num) {
            throw new AnalysysException("Too many super properties. max number is 100.");
        }
        ValidHandle.checkParam("", params);
        for (String key : params.keySet()) {
            this.xcontextSuperProperties.put(key, params.get(key));
        }
        if (this.isDebug()) {
            System.out.println("registerSuperProperties success");
        }
    }

    public void unRegisterSuperProperty(String key) {
        if (this.xcontextSuperProperties.containsKey(key)) {
            this.xcontextSuperProperties.remove(key);
        }
        if (this.isDebug()) {
            System.out.println(String.format("unRegisterSuperProperty %s success", key));
        }
    }

    public Object getSuperPropertie(String key) {
        if (this.xcontextSuperProperties.containsKey(key)) {
            return this.xcontextSuperProperties.get(key);
        }
        return null;
    }

    public Map<String, Object> getSuperProperties() {
        return this.xcontextSuperProperties;
    }

    public void clearSuperProperties() {
        this.xcontextSuperProperties.clear();
        if (this.isDebug()) {
            System.out.println("clearSuperProperties success");
        }
    }

    public void flush() {
        this.collecter.flush();
    }

    public void shutdown() {
        this.collecter.close();
    }

    public void profileSet(String distinctId, boolean isLogin, Map<String, Object> properties, String platform) throws AnalysysException {
        this.upload(distinctId, isLogin, EventName.P_SET.getValue(), properties, platform, null);
    }

    public void profileSet(String distinctId, boolean isLogin, Map<String, Object> properties, String platform, String xwhen) throws AnalysysException {
        this.upload(distinctId, isLogin, EventName.P_SET.getValue(), properties, platform, xwhen);
    }

    public void profileSetOnce(String distinctId, boolean isLogin, Map<String, Object> properties, String platform) throws AnalysysException {
        this.upload(distinctId, isLogin, EventName.P_SET_ONE.getValue(), properties, platform, null);
    }

    public void profileSetOnce(String distinctId, boolean isLogin, Map<String, Object> properties, String platform, String xwhen) throws AnalysysException {
        this.upload(distinctId, isLogin, EventName.P_SET_ONE.getValue(), properties, platform, xwhen);
    }

    public void profileIncrement(String distinctId, boolean isLogin, Map<String, Object> properties, String platform) throws AnalysysException {
        this.upload(distinctId, isLogin, EventName.P_IN.getValue(), properties, platform, null);
    }

    public void profileIncrement(String distinctId, boolean isLogin, Map<String, Object> properties, String platform, String xwhen) throws AnalysysException {
        this.upload(distinctId, isLogin, EventName.P_IN.getValue(), properties, platform, xwhen);
    }

    public void profileAppend(String distinctId, boolean isLogin, Map<String, Object> properties, String platform) throws AnalysysException {
        this.upload(distinctId, isLogin, EventName.P_APP.getValue(), properties, platform, null);
    }

    public void profileAppend(String distinctId, boolean isLogin, Map<String, Object> properties, String platform, String xwhen) throws AnalysysException {
        this.upload(distinctId, isLogin, EventName.P_APP.getValue(), properties, platform, xwhen);
    }

    public void profileUnSet(String distinctId, boolean isLogin, String property, String platform) throws AnalysysException {
        HashMap<String, Object> properties = new HashMap<String, Object>(2);
        properties.put(property, "");
        this.upload(distinctId, isLogin, EventName.P_UN.getValue(), properties, platform, null);
    }

    public void profileUnSet(String distinctId, boolean isLogin, String property, String platform, String xwhen) throws AnalysysException {
        HashMap<String, Object> properties = new HashMap<String, Object>(2);
        properties.put(property, "");
        this.upload(distinctId, isLogin, EventName.P_UN.getValue(), properties, platform, xwhen);
    }

    public void profileDelete(String distinctId, boolean isLogin, String platform) throws AnalysysException {
        this.upload(distinctId, isLogin, EventName.P_DEL.getValue(), new HashMap<String, Object>(1), platform, null);
    }

    public void profileDelete(String distinctId, boolean isLogin, String platform, String xwhen) throws AnalysysException {
        this.upload(distinctId, isLogin, EventName.P_DEL.getValue(), new HashMap<String, Object>(1), platform, xwhen);
    }

    public void alias(String aliasId, String distinctId, String platform) throws AnalysysException {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("$original_id", distinctId);
        this.upload(aliasId, true, EventName.ALIAS.getValue(), param, platform, null);
    }

    public void alias(String aliasId, String distinctId, String platform, String xwhen) throws AnalysysException {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("$original_id", distinctId);
        this.upload(aliasId, true, EventName.ALIAS.getValue(), param, platform, xwhen);
    }

    public void track(String distinctId, boolean isLogin, String eventName, Map<String, Object> properties, String platform) throws AnalysysException {
        this.upload(distinctId, isLogin, eventName, properties, platform, null);
    }

    public void track(String distinctId, boolean isLogin, String eventName, Map<String, Object> properties, String platform, String xwhen) throws AnalysysException {
        this.upload(distinctId, isLogin, eventName, properties, platform, xwhen);
    }

    private void upload(String distinctId, boolean isLogin, String eventName, Map<String, Object> properties, String platform, String xwhen) throws AnalysysException {
        ValidHandle.checkProperty(distinctId, eventName, properties, this.xcontextSuperProperties.size());
        HashMap<String, Object> eventMap = new HashMap<String, Object>(8);
        eventMap.put("xwho", distinctId);
        if (xwhen != null && xwhen.trim().length() > 0) {
            if (xwhen.trim().length() != 13) {
                throw new AnalysysException(String.format("The param xwhen %s not a millisecond timestamp.", xwhen.trim()));
            }
            try {
                long when = Long.valueOf(xwhen.trim());
                new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(new Date(when));
                eventMap.put("xwhen", when);
            }
            catch (Exception e) {
                throw new AnalysysException(String.format("The param xwhen %s not a timestamp.", xwhen.trim()));
            }
        } else if (EventName.ALIAS.getValue().equals(eventName)) {
            eventMap.put("xwhen", System.currentTimeMillis() - 3L);
        } else {
            eventMap.put("xwhen", System.currentTimeMillis());
        }
        eventMap.put("xwhat", eventName);
        eventMap.put("appid", this.appId);
        HashMap<String, Object> newProperties = new HashMap<String, Object>(16);
        String profile = "$profile";
        if (!eventName.startsWith(profile) && !eventName.startsWith(EventName.ALIAS.getValue())) {
            newProperties.putAll(this.xcontextSuperProperties);
        }
        newProperties.put("$debug", this.debugMode);
        if (properties != null) {
            newProperties.putAll(properties);
        }
        newProperties.putAll(this.egBaseProperties);
        newProperties.put("$is_login", isLogin);
        String newPlatForm = this.getPlatForm(platform);
        if (newPlatForm != null && newPlatForm.trim().length() > 0) {
            newProperties.put("$platform", newPlatForm);
        }
        eventMap.put("xcontext", newProperties);
        this.collecter.debug(this.isDebug());
        boolean ret = this.collecter.send(eventMap);
        if (eventName.startsWith(profile) && this.isDebug() && ret) {
            System.out.println(String.format("%s success.", eventName.substring(1)));
        }
    }

    private String getPlatForm(String platform) {
        if (PlatForm.JS.getValue().equalsIgnoreCase(platform)) {
            return PlatForm.JS.getValue();
        }
        if (PlatForm.WeChat.getValue().equalsIgnoreCase(platform)) {
            return PlatForm.WeChat.getValue();
        }
        if (PlatForm.Android.getValue().equalsIgnoreCase(platform)) {
            return PlatForm.Android.getValue();
        }
        if (PlatForm.iOS.getValue().equalsIgnoreCase(platform)) {
            return PlatForm.iOS.getValue();
        }
        System.out.println(String.format("Warning: param platform:%s  Your input are not:iOS/Android/JS/WeChat.", platform == null ? "" : platform));
        if (PlatForm.Java.getValue().equalsIgnoreCase(platform)) {
            return PlatForm.Java.getValue();
        }
        if (PlatForm.python.getValue().equalsIgnoreCase(platform)) {
            return PlatForm.python.getValue();
        }
        if (PlatForm.Node.getValue().equalsIgnoreCase(platform)) {
            return PlatForm.Node.getValue();
        }
        if (PlatForm.PHP.getValue().equalsIgnoreCase(platform)) {
            return PlatForm.PHP.getValue();
        }
        if (platform == null || platform.trim().length() == 0) {
            return "";
        }
        return platform;
    }
}

